/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.CentrifugalPump;

import com.adonis.fluid.block.CentrifugalPump.CentrifugalPumpBlock;
import com.adonis.fluid.block.CentrifugalPump.CentrifugalPumpBlockEntity;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;

public class CentrifugalPumpVisual
extends KineticBlockEntityVisual<CentrifugalPumpBlockEntity> {
    protected final RotatingInstance shaft;
    protected final Direction shaftDirection;

    public CentrifugalPumpVisual(VisualizationContext context, CentrifugalPumpBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        BlockState state = blockEntity.m_58900_();
        this.shaftDirection = CentrifugalPumpBlock.getShaftDirection(state);
        Direction opposite = this.shaftDirection.m_122424_();
        AttachFace face = (AttachFace)state.m_61143_(CentrifugalPumpBlock.FACE);
        this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF)).createInstance();
        this.setupShaft(blockEntity, state, face, opposite);
    }

    private void setupShaft(CentrifugalPumpBlockEntity be, BlockState state, AttachFace face, Direction shaftOpposite) {
        this.shaft.setup((KineticBlockEntity)be).setPosition((Vec3i)this.getVisualPosition());
        if (face == AttachFace.WALL) {
            this.shaft.rotateToFace(Direction.SOUTH, this.shaftDirection);
        } else {
            Direction facing = (Direction)state.m_61143_((Property)CentrifugalPumpBlock.FACING);
            if (face == AttachFace.FLOOR) {
                this.shaft.rotateToFace(Direction.SOUTH, this.shaftDirection);
            } else {
                this.shaft.rotateToFace(Direction.NORTH, shaftOpposite);
            }
        }
        this.shaft.setChanged();
    }

    public void update(float pt) {
        if (this.shaft != null) {
            this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        }
    }

    public void updateLight(float partialTick) {
        if (this.shaft != null) {
            this.relight(new FlatLit[]{this.shaft});
        }
    }

    protected void _delete() {
        if (this.shaft != null) {
            this.shaft.delete();
        }
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        if (this.shaft != null) {
            consumer.accept((Instance)this.shaft);
        }
    }
}

