/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.CentrifugalPump;

import com.adonis.fluid.block.CentrifugalPump.CentrifugalPumpBlock;
import com.adonis.fluid.mixin.accessor.PipeConnectionAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeConnection;
import com.simibubi.create.content.fluids.pump.PumpBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.BlockFace;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CentrifugalPumpBlockEntity
extends KineticBlockEntity {
    public ScrollOptionBehaviour<PumpMode> pumpMode;
    Couple<MutableBoolean> sidesToUpdate = Couple.create(MutableBoolean::new);
    boolean pressureUpdate;
    private boolean isEncased = false;
    private static final int BASE_PUMP_RANGE = 20;
    private static final float SPEED_MULTIPLIER = 2.0f;
    private int networkCheckTimer = 0;
    private static final int CHECK_INTERVAL = 20;
    private boolean networkInitialized = false;

    public CentrifugalPumpBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void onEncasedStateChanged(boolean encased) {
        this.isEncased = encased;
        this.updatePressureChange();
        this.notifyUpdate();
    }

    public void onFluidContainerDetected(Direction dir) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        FluidTransportBehaviour behaviour = (FluidTransportBehaviour)this.getBehaviour(FluidTransportBehaviour.TYPE);
        if (behaviour != null) {
            PipeConnection connection = behaviour.getConnection(dir);
            if (connection == null) {
                this.pressureUpdate = true;
                this.updatePipeNetwork(dir == this.getFront());
            } else {
                PipeConnectionAccessor accessor = (PipeConnectionAccessor)connection;
                if (!accessor.getSource().isPresent()) {
                    connection.determineSource(this.f_58857_, this.f_58858_);
                    this.updatePipeNetwork(dir == this.getFront());
                } else {
                    connection.determineSource(this.f_58857_, this.f_58858_);
                }
            }
        }
        FluidPropagator.propagateChangedPipe((LevelAccessor)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)this.m_58900_());
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        boolean isCurrentlyEncased;
        super.addBehaviours(behaviours);
        behaviours.add((BlockEntityBehaviour)new CentrifugalPumpFluidTransferBehaviour((SmartBlockEntity)this));
        BlockState state = this.m_58900_();
        boolean bl = isCurrentlyEncased = state.m_61138_((Property)CentrifugalPumpBlock.ENCASED) && (Boolean)state.m_61143_((Property)CentrifugalPumpBlock.ENCASED) != false;
        if (!isCurrentlyEncased) {
            this.pumpMode = new ScrollOptionBehaviour(PumpMode.class, (Component)Component.m_237115_((String)"create_fluid.centrifugal_pump.pump_mode"), (SmartBlockEntity)this, (ValueBoxTransform)new CentrifugalPumpValueBox());
            this.pumpMode.withCallback(i -> this.onModeChanged());
            behaviours.add((BlockEntityBehaviour)this.pumpMode);
        }
        this.isEncased = isCurrentlyEncased;
        this.registerAwardables(behaviours, FluidPropagator.getSharedTriggers());
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.PUMP});
    }

    public void initialize() {
        super.initialize();
        this.networkInitialized = false;
        this.pressureUpdate = true;
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (level != null && !level.f_46443_) {
            this.networkInitialized = false;
            this.pressureUpdate = true;
        }
    }

    public void onModeChanged() {
        if (!this.f_58857_.f_46443_ || this.isVirtual()) {
            this.updatePressureChange();
        }
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_ || this.isVirtual()) {
            if (!this.networkInitialized) {
                this.networkInitialized = true;
                this.updatePressureChange();
                this.checkForFluidContainers();
                return;
            }
            if (++this.networkCheckTimer >= 20) {
                this.networkCheckTimer = 0;
                this.checkForMissingConnections();
            }
            if (this.pressureUpdate) {
                this.updatePressureChange();
                return;
            }
            Direction primary = this.getFront();
            Direction secondary = this.getSecondaryFront();
            if (primary != null && secondary != null) {
                MutableBoolean secondaryUpdate;
                MutableBoolean primaryUpdate = (MutableBoolean)this.sidesToUpdate.getFirst();
                if (!primaryUpdate.isFalse()) {
                    primaryUpdate.setFalse();
                    this.distributePressureTo(primary);
                }
                if (!(secondaryUpdate = (MutableBoolean)this.sidesToUpdate.getSecond()).isFalse()) {
                    secondaryUpdate.setFalse();
                    this.distributePressureTo(secondary);
                }
            }
        }
    }

    private void checkForMissingConnections() {
        Direction primary = this.getFront();
        Direction secondary = this.getSecondaryFront();
        if (primary == null || secondary == null) {
            return;
        }
        FluidTransportBehaviour behaviour = (FluidTransportBehaviour)this.getBehaviour(FluidTransportBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        this.checkDirectionForContainer(primary, behaviour);
        this.checkDirectionForContainer(secondary, behaviour);
    }

    private void checkDirectionForContainer(Direction dir, FluidTransportBehaviour behaviour) {
        PipeConnection connection = behaviour.getConnection(dir);
        if (connection != null && connection.hasFlow()) {
            return;
        }
        BlockPos targetPos = this.f_58858_.m_121945_(dir);
        if (!this.f_58857_.m_46749_(targetPos)) {
            return;
        }
        BlockEntity targetBE = this.f_58857_.m_7702_(targetPos);
        if (targetBE == null) {
            return;
        }
        LazyOptional capability = targetBE.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_());
        if (!capability.isPresent()) {
            capability = targetBE.getCapability(ForgeCapabilities.FLUID_HANDLER, null);
        }
        if (capability.isPresent()) {
            if (connection == null) {
                this.pressureUpdate = true;
            } else {
                PipeConnectionAccessor accessor = (PipeConnectionAccessor)connection;
                if (!accessor.getSource().isPresent()) {
                    connection.determineSource(this.f_58857_, this.f_58858_);
                }
            }
        }
    }

    private void checkForFluidContainers() {
        Direction primary = this.getFront();
        Direction secondary = this.getSecondaryFront();
        if (primary == null || secondary == null) {
            return;
        }
        boolean foundContainer = false;
        if (this.hasFluidContainer(primary)) {
            foundContainer = true;
        }
        if (this.hasFluidContainer(secondary)) {
            foundContainer = true;
        }
        if (foundContainer) {
            this.pressureUpdate = true;
        }
    }

    private boolean hasFluidContainer(Direction dir) {
        BlockPos targetPos = this.f_58858_.m_121945_(dir);
        if (!this.f_58857_.m_46749_(targetPos)) {
            return false;
        }
        BlockEntity targetBE = this.f_58857_.m_7702_(targetPos);
        if (targetBE == null) {
            return false;
        }
        LazyOptional capability = targetBE.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_());
        if (!capability.isPresent()) {
            capability = targetBE.getCapability(ForgeCapabilities.FLUID_HANDLER, null);
        }
        return capability.isPresent();
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (Math.abs(previousSpeed) != Math.abs(this.getSpeed())) {
            if (this.speed != 0.0f) {
                this.award(AllAdvancements.PUMP);
            }
            if (!this.f_58857_.f_46443_ || this.isVirtual()) {
                this.updatePressureChange();
            }
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public void updatePressureChange() {
        this.pressureUpdate = false;
        Direction primary = this.getFront();
        Direction secondary = this.getSecondaryFront();
        if (primary == null || secondary == null) {
            return;
        }
        BlockPos primaryPos = this.f_58858_.m_121945_(primary);
        BlockPos secondaryPos = this.f_58858_.m_121945_(secondary);
        FluidPropagator.propagateChangedPipe((LevelAccessor)this.f_58857_, (BlockPos)primaryPos, (BlockState)this.f_58857_.m_8055_(primaryPos));
        FluidPropagator.propagateChangedPipe((LevelAccessor)this.f_58857_, (BlockPos)secondaryPos, (BlockState)this.f_58857_.m_8055_(secondaryPos));
        FluidTransportBehaviour behaviour = (FluidTransportBehaviour)this.getBehaviour(FluidTransportBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.wipePressure();
        }
        this.sidesToUpdate.forEach(MutableBoolean::setTrue);
    }

    public void onPipeNetworkChanged() {
        if (!this.f_58857_.f_46443_ || this.isVirtual()) {
            FluidTransportBehaviour behaviour = (FluidTransportBehaviour)this.getBehaviour(FluidTransportBehaviour.TYPE);
            if (behaviour != null) {
                behaviour.wipePressure();
            }
            this.pressureUpdate = true;
            this.sidesToUpdate.forEach(MutableBoolean::setTrue);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.m_128441_("Encased")) {
            this.isEncased = compound.m_128471_("Encased");
        }
        if (compound.m_128441_("PumpMode") && !this.isEncased && this.pumpMode != null) {
            try {
                String mode = compound.m_128461_("PumpMode");
                PumpMode pMode = PumpMode.valueOf(mode);
                this.pumpMode.setValue(pMode.ordinal());
            }
            catch (Exception e) {
                if (compound.m_128441_("PumpModeOrdinal")) {
                    this.pumpMode.setValue(compound.m_128451_("PumpModeOrdinal"));
                }
                this.pumpMode.setValue(0);
            }
        }
        if (!clientPacket) {
            this.networkInitialized = false;
            this.pressureUpdate = true;
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128379_("Encased", this.isEncased);
        if (this.pumpMode != null && !this.isEncased) {
            compound.m_128359_("PumpMode", ((PumpMode)this.pumpMode.get()).name());
            compound.m_128405_("PumpModeOrdinal", this.pumpMode.getValue());
        }
    }

    protected void distributePressureTo(Direction side) {
        PipeConnection connection;
        if (this.getSpeed() == 0.0f) {
            return;
        }
        BlockFace start = new BlockFace(this.f_58858_, side);
        boolean isPrimary = side == this.getFront();
        boolean pull = this.isPullingOnSide(isPrimary);
        HashSet<BlockFace> targets = new HashSet<BlockFace>();
        HashMap<BlockPos, Pair<Integer, Map<Direction, Boolean>>> pipeGraph = new HashMap<BlockPos, Pair<Integer, Map<Direction, Boolean>>>();
        if (!pull) {
            FluidPropagator.resetAffectedFluidNetworks((Level)this.f_58857_, (BlockPos)this.f_58858_, (Direction)side.m_122424_());
        }
        int maxDistance = 20;
        if (!this.hasReachedValidEndpoint((LevelAccessor)this.f_58857_, start, pull)) {
            ((Map)pipeGraph.computeIfAbsent(this.f_58858_, $ -> Pair.of((Object)0, new IdentityHashMap())).getSecond()).put(side, pull);
            ((Map)pipeGraph.computeIfAbsent(start.getConnectedPos(), $ -> Pair.of((Object)1, new IdentityHashMap())).getSecond()).put(side.m_122424_(), !pull);
            ArrayList<Pair> frontier = new ArrayList<Pair>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            frontier.add(Pair.of((Object)1, (Object)start.getConnectedPos()));
            while (!frontier.isEmpty()) {
                Pair entry = (Pair)frontier.remove(0);
                int distance = (Integer)entry.getFirst();
                BlockPos currentPos = (BlockPos)entry.getSecond();
                if (!this.f_58857_.m_46749_(currentPos) || visited.contains(currentPos)) continue;
                visited.add(currentPos);
                BlockState currentState = this.f_58857_.m_8055_(currentPos);
                FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)this.f_58857_, (BlockPos)currentPos);
                if (pipe == null) continue;
                for (Direction face : FluidPropagator.getPipeConnections((BlockState)currentState, (FluidTransportBehaviour)pipe)) {
                    BlockFace blockFace = new BlockFace(currentPos, face);
                    BlockPos connectedPos = blockFace.getConnectedPos();
                    if (!this.f_58857_.m_46749_(connectedPos) || blockFace.isEquivalent(start)) continue;
                    if (this.hasReachedValidEndpoint((LevelAccessor)this.f_58857_, blockFace, pull)) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((BlockGetter)this.f_58857_, (BlockPos)connectedPos);
                    if (pipeBehaviour == null || pipeBehaviour instanceof CentrifugalPumpFluidTransferBehaviour || visited.contains(connectedPos)) continue;
                    if (distance + 1 >= maxDistance) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                    ((Map)pipeGraph.computeIfAbsent(connectedPos, $ -> Pair.of((Object)(distance + 1), new IdentityHashMap())).getSecond()).put(face.m_122424_(), !pull);
                    frontier.add(Pair.of((Object)(distance + 1), (Object)connectedPos));
                }
            }
        }
        HashMap<Integer, Set<BlockFace>> validFaces = new HashMap<Integer, Set<BlockFace>>();
        this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(start.getPos(), start.getOppositeFace()), pull);
        float pressure = Math.abs(this.getSpeed()) * 2.0f;
        for (Set set : validFaces.values()) {
            int branches = Math.max(1, set.size() - 1);
            for (BlockFace face : set) {
                BlockPos pipePos = face.getPos();
                Direction pipeSide = face.getFace();
                if (pipePos.equals((Object)this.f_58858_)) continue;
                boolean inbound = (Boolean)((Map)((Pair)pipeGraph.get(pipePos)).getSecond()).get(pipeSide);
                FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((BlockGetter)this.f_58857_, (BlockPos)pipePos);
                if (pipeBehaviour == null) continue;
                pipeBehaviour.addPressure(pipeSide, inbound, pressure / (float)branches);
            }
        }
        FluidTransportBehaviour behaviour = (FluidTransportBehaviour)this.getBehaviour(FluidTransportBehaviour.TYPE);
        if (behaviour != null && (connection = behaviour.getConnection(side)) != null) {
            connection.determineSource(this.f_58857_, this.f_58858_);
        }
    }

    protected boolean searchForEndpointRecursively(Map<BlockPos, Pair<Integer, Map<Direction, Boolean>>> pipeGraph, Set<BlockFace> targets, Map<Integer, Set<BlockFace>> validFaces, BlockFace currentFace, boolean pull) {
        BlockPos currentPos = currentFace.getPos();
        if (!pipeGraph.containsKey(currentPos)) {
            return false;
        }
        Pair<Integer, Map<Direction, Boolean>> pair = pipeGraph.get(currentPos);
        int distance = (Integer)pair.getFirst();
        boolean atLeastOneBranchSuccessful = false;
        for (Direction nextFacing : Iterate.directions) {
            Map map;
            if (nextFacing == currentFace.getFace() || !(map = (Map)pair.getSecond()).containsKey(nextFacing)) continue;
            BlockFace localTarget = new BlockFace(currentPos, nextFacing);
            if (targets.contains(localTarget)) {
                validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(localTarget);
                atLeastOneBranchSuccessful = true;
                continue;
            }
            if ((Boolean)map.get(nextFacing) != pull || !this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(currentPos.m_121945_(nextFacing), nextFacing.m_122424_()), pull)) continue;
            validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(localTarget);
            atLeastOneBranchSuccessful = true;
        }
        if (atLeastOneBranchSuccessful) {
            validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(currentFace);
        }
        return atLeastOneBranchSuccessful;
    }

    private boolean hasReachedValidEndpoint(LevelAccessor world, BlockFace blockFace, boolean pull) {
        BlockPos connectedPos = blockFace.getConnectedPos();
        BlockState connectedState = world.m_8055_(connectedPos);
        BlockEntity blockEntity = world.m_7702_(connectedPos);
        Direction face = blockFace.getFace();
        if (connectedState.m_60734_() instanceof CentrifugalPumpBlock && blockEntity instanceof CentrifugalPumpBlockEntity) {
            boolean connectsToSecondary;
            CentrifugalPumpBlockEntity otherPump = (CentrifugalPumpBlockEntity)blockEntity;
            Direction otherPrimary = CentrifugalPumpBlock.getPrimaryFluidDirection(connectedState);
            Direction otherSecondary = CentrifugalPumpBlock.getSecondaryFluidDirection(connectedState);
            boolean connectsToPrimary = face.m_122424_() == otherPrimary;
            boolean bl = connectsToSecondary = face.m_122424_() == otherSecondary;
            if (connectsToPrimary || connectsToSecondary) {
                boolean otherPull = otherPump.isPullingOnSide(connectsToPrimary);
                return otherPull != pull;
            }
            return false;
        }
        if (PumpBlock.isPump((BlockState)connectedState) && ((Direction)connectedState.m_61143_((Property)PumpBlock.FACING)).m_122434_() == face.m_122434_()) {
            return true;
        }
        FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)world, (BlockPos)connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, blockFace.getOppositeFace())) {
            return false;
        }
        if (blockEntity != null) {
            LazyOptional capability = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, face.m_122424_());
            if (!capability.isPresent()) {
                capability = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, null);
            }
            if (capability.isPresent()) {
                return true;
            }
        }
        return FluidPropagator.isOpenEnd((BlockGetter)world, (BlockPos)blockFace.getPos(), (Direction)face);
    }

    public void updatePipesOnSide(Direction side) {
        if (this.isSideAccessible(side)) {
            this.updatePipeNetwork(side == this.getFront());
            FluidTransportBehaviour behaviour = (FluidTransportBehaviour)this.getBehaviour(FluidTransportBehaviour.TYPE);
            if (behaviour != null) {
                behaviour.wipePressure();
            }
        }
    }

    protected boolean isFront(Direction side) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof CentrifugalPumpBlock)) {
            return false;
        }
        return side == CentrifugalPumpBlock.getPrimaryFluidDirection(blockState) || side == CentrifugalPumpBlock.getSecondaryFluidDirection(blockState);
    }

    @Nullable
    protected Direction getFront() {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof CentrifugalPumpBlock)) {
            return null;
        }
        return CentrifugalPumpBlock.getPrimaryFluidDirection(blockState);
    }

    @Nullable
    protected Direction getSecondaryFront() {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof CentrifugalPumpBlock)) {
            return null;
        }
        return CentrifugalPumpBlock.getSecondaryFluidDirection(blockState);
    }

    protected void updatePipeNetwork(boolean front) {
        ((MutableBoolean)this.sidesToUpdate.get(front)).setTrue();
    }

    public boolean isSideAccessible(Direction side) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof CentrifugalPumpBlock)) {
            return false;
        }
        return CentrifugalPumpBlock.isOpenAt(blockState, side);
    }

    public boolean isPullingOnSide(boolean isPrimaryDirection) {
        boolean pumpIn;
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)CentrifugalPumpBlock.ENCASED) && ((Boolean)state.m_61143_((Property)CentrifugalPumpBlock.ENCASED)).booleanValue()) {
            boolean pumpIn2;
            boolean bl = pumpIn2 = this.getSpeed() < 0.0f;
            return pumpIn2 ? isPrimaryDirection : !isPrimaryDirection;
        }
        if (this.pumpMode == null) {
            return !isPrimaryDirection;
        }
        boolean bl = pumpIn = this.pumpMode.get() == PumpMode.PUMP_IN;
        return pumpIn ? isPrimaryDirection : !isPrimaryDirection;
    }

    class CentrifugalPumpFluidTransferBehaviour
    extends FluidTransportBehaviour {
        public CentrifugalPumpFluidTransferBehaviour(SmartBlockEntity be) {
            super(be);
        }

        public void tick() {
            super.tick();
            if (CentrifugalPumpBlockEntity.this.getSpeed() == 0.0f) {
                return;
            }
            Direction primary = CentrifugalPumpBlockEntity.this.getFront();
            Direction secondary = CentrifugalPumpBlockEntity.this.getSecondaryFront();
            if (primary == null || secondary == null) {
                return;
            }
            this.updatePressures(primary, secondary);
        }

        private void updatePressures(Direction primary, Direction secondary) {
            for (Map.Entry entry : this.interfaces.entrySet()) {
                boolean pull;
                Direction dir = (Direction)entry.getKey();
                PipeConnectionAccessor accessor = (PipeConnectionAccessor)entry.getValue();
                Couple<Float> pressure = accessor.getPressure();
                float pumpPressure = Math.abs(CentrifugalPumpBlockEntity.this.getSpeed()) * 2.0f;
                if (dir == primary) {
                    pull = CentrifugalPumpBlockEntity.this.isPullingOnSide(true);
                    pressure.set(pull, (Object)Float.valueOf(pumpPressure));
                    pressure.set(!pull, (Object)Float.valueOf(0.0f));
                    continue;
                }
                if (dir == secondary) {
                    pull = CentrifugalPumpBlockEntity.this.isPullingOnSide(false);
                    pressure.set(pull, (Object)Float.valueOf(pumpPressure));
                    pressure.set(!pull, (Object)Float.valueOf(0.0f));
                    continue;
                }
                pressure.set(true, (Object)Float.valueOf(0.0f));
                pressure.set(false, (Object)Float.valueOf(0.0f));
            }
        }

        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return CentrifugalPumpBlockEntity.this.isSideAccessible(direction);
        }
    }

    public static enum PumpMode implements INamedIconOptions
    {
        PUMP_IN(AllIcons.I_REFRESH),
        PUMP_OUT(AllIcons.I_ROTATE_CCW);

        private String translationKey;
        private AllIcons icon;

        private PumpMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "create_fluid.centrifugal_pump.mode." + Lang.asId((String)this.name());
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    public static class CentrifugalPumpValueBox
    extends ValueBoxTransform.Sided {
        protected boolean isSideActive(BlockState state, Direction side) {
            if (state.m_61138_((Property)CentrifugalPumpBlock.ENCASED) && ((Boolean)state.m_61143_((Property)CentrifugalPumpBlock.ENCASED)).booleanValue()) {
                return false;
            }
            if (!(state.m_60734_() instanceof CentrifugalPumpBlock)) {
                return false;
            }
            AttachFace face = (AttachFace)state.m_61143_(CentrifugalPumpBlock.FACE);
            Direction facing = (Direction)state.m_61143_((Property)CentrifugalPumpBlock.FACING);
            if (face == AttachFace.WALL) {
                if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                    return side == Direction.WEST || side == Direction.EAST;
                }
                return side == Direction.NORTH || side == Direction.SOUTH;
            }
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                return side == Direction.WEST || side == Direction.EAST;
            }
            return side == Direction.NORTH || side == Direction.SOUTH;
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)16.0);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction side = this.getSide();
            if (side == null) {
                AttachFace face = (AttachFace)state.m_61143_(CentrifugalPumpBlock.FACE);
                Direction facing = (Direction)state.m_61143_((Property)CentrifugalPumpBlock.FACING);
                side = face == AttachFace.WALL ? (facing == Direction.NORTH || facing == Direction.SOUTH ? Direction.WEST : Direction.NORTH) : (facing == Direction.NORTH || facing == Direction.SOUTH ? Direction.WEST : Direction.NORTH);
            }
            float offset = 15.5f;
            switch (side) {
                case NORTH: {
                    return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)(16.0f - offset));
                }
                case SOUTH: {
                    return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)offset);
                }
                case WEST: {
                    return VecHelper.voxelSpace((double)(16.0f - offset), (double)8.0, (double)8.0);
                }
                case EAST: {
                    return VecHelper.voxelSpace((double)offset, (double)8.0, (double)8.0);
                }
            }
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)offset);
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            AttachFace face;
            Direction side = this.getSide();
            if (side == null) {
                face = (AttachFace)state.m_61143_(CentrifugalPumpBlock.FACE);
                Direction facing = (Direction)state.m_61143_((Property)CentrifugalPumpBlock.FACING);
                side = face == AttachFace.WALL ? (facing == Direction.NORTH || facing == Direction.SOUTH ? Direction.WEST : Direction.NORTH) : (facing == Direction.NORTH || facing == Direction.SOUTH ? Direction.WEST : Direction.NORTH);
            }
            face = (AttachFace)state.m_61143_(CentrifugalPumpBlock.FACE);
            float yRot = AngleHelper.horizontalAngle((Direction)side) + 180.0f;
            TransformStack.of((PoseStack)ms).rotateYDegrees(yRot);
            if (face == AttachFace.CEILING) {
                TransformStack.of((PoseStack)ms).rotateZDegrees(180.0f);
            }
        }
    }
}

