/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.Aqueduct;

import com.adonis.fluid.block.Aqueduct.AbstractAqueductBlock;
import com.adonis.fluid.config.CFCommonConfig;
import com.adonis.fluid.content.aqueduct.FluidFlowAnimation;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAqueductBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAqueductBlockEntity.class);
    protected SmartFluidTank tank;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected LerpedFloat fluidLevel;
    @OnlyIn(value=Dist.CLIENT)
    protected FluidFlowAnimation flowAnimation;
    protected boolean locked = false;
    protected static final int CAPACITY = 1000;
    protected WorkingState workingState = WorkingState.IDLE;
    protected BlockPos workingPartner = null;
    protected int transferCooldown = 0;
    private boolean dataLoaded = false;
    private CompoundTag pendingTankData = null;

    public AbstractAqueductBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.initializeTank();
        this.fluidLevel = LerpedFloat.linear().startWithValue(0.0);
    }

    private void initializeTank() {
        this.tank = new SmartFluidTank(1000, this::onFluidStackChanged);
        this.fluidCapability = LazyOptional.of(() -> new AqueductFluidHandler());
    }

    public void onLoad() {
        super.onLoad();
        if (!this.dataLoaded && this.pendingTankData != null) {
            this.tank.readFromNBT(this.pendingTankData);
            this.pendingTankData = null;
            this.dataLoaded = true;
            float currentLevel = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
            this.fluidLevel.startWithValue((double)currentLevel);
            if (!this.f_58857_.f_46443_) {
                this.sendData();
            }
        }
        if (this.f_58857_.f_46443_ && this.flowAnimation == null) {
            this.flowAnimation = new FluidFlowAnimation();
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.f_58857_.f_46443_) {
            float targetLevel = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
            this.fluidLevel.chase((double)targetLevel, 0.25, LerpedFloat.Chaser.LINEAR);
            this.m_6596_();
            this.sendData();
        }
    }

    public void tick() {
        super.tick();
        this.fluidLevel.tickChaser();
        if (this.f_58857_.f_46443_) {
            this.tickClient();
        } else {
            this.tickServer();
        }
    }

    protected void tickClient() {
        if (this.flowAnimation != null && !this.tank.isEmpty()) {
            this.flowAnimation.tick();
        }
    }

    protected void tickServer() {
        if (this.transferCooldown > 0) {
            --this.transferCooldown;
        }
        if (this.workingState == WorkingState.SOURCE && this.workingPartner != null) {
            this.performTransferToPartner();
        }
    }

    private void performTransferToPartner() {
        if (this.workingPartner == null || this.tank.isEmpty()) {
            this.clearWorkingState();
            return;
        }
        BlockEntity partnerBE = this.f_58857_.m_7702_(this.workingPartner);
        if (!(partnerBE instanceof AbstractAqueductBlockEntity)) {
            this.clearWorkingState();
            return;
        }
        AbstractAqueductBlockEntity partner = (AbstractAqueductBlockEntity)partnerBE;
        if (partner.workingState != WorkingState.TARGET) {
            this.clearWorkingState();
            return;
        }
        int transferRate = this.getTransferRate();
        int canDrain = Math.min(transferRate, this.tank.getFluidAmount());
        int canFill = Math.min(canDrain, partner.getSpace());
        if (canFill <= 0) {
            this.clearWorkingState();
            partner.clearWorkingState();
            return;
        }
        FluidStack toTransfer = this.tank.getFluid().copy();
        toTransfer.setAmount(canFill);
        this.tank.drain(toTransfer, IFluidHandler.FluidAction.EXECUTE);
        partner.tank.fill(toTransfer, IFluidHandler.FluidAction.EXECUTE);
        if (this.tank.isEmpty()) {
            this.clearWorkingState();
            partner.clearWorkingState();
        }
    }

    public void clearWorkingState() {
        this.workingState = WorkingState.IDLE;
        this.workingPartner = null;
        this.m_6596_();
    }

    public void setAsSource(BlockPos partner) {
        this.workingState = WorkingState.SOURCE;
        this.workingPartner = partner;
        this.m_6596_();
    }

    public void setAsTarget(BlockPos partner) {
        this.workingState = WorkingState.TARGET;
        this.workingPartner = partner;
        this.m_6596_();
    }

    public boolean isWorking() {
        return this.workingState != WorkingState.IDLE;
    }

    public boolean canBeSource() {
        return !this.locked && !this.tank.isEmpty() && this.workingState == WorkingState.IDLE;
    }

    public boolean canBeTarget(FluidStack fluid) {
        if (this.locked || this.workingState != WorkingState.IDLE) {
            return false;
        }
        if (this.tank.isEmpty()) {
            return true;
        }
        if (this.tank.getFluidAmount() >= this.tank.getCapacity()) {
            return false;
        }
        return this.tank.getFluid().isFluidEqual(fluid);
    }

    public boolean canSkip(FluidStack fluid) {
        if (this.locked || this.workingState != WorkingState.IDLE) {
            return false;
        }
        return this.tank.getFluidAmount() >= this.tank.getCapacity() && this.tank.getFluid().isFluidEqual(fluid);
    }

    public Direction getFlowDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)AbstractAqueductBlock.FACING);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        if (this.locked != locked) {
            this.locked = locked;
            if (locked && this.isWorking()) {
                this.clearWorkingState();
            }
            this.m_6596_();
        }
    }

    public float getFluidLevel() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    public float getRenderedFluidLevel(float partialTicks) {
        return this.fluidLevel.getValue(partialTicks);
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int getSpace() {
        return this.tank.getCapacity() - this.tank.getFluidAmount();
    }

    public boolean isFull() {
        return this.tank.getFluidAmount() >= this.tank.getCapacity();
    }

    public boolean isEmpty() {
        return this.tank.isEmpty();
    }

    public SmartFluidTank getTank() {
        return this.tank;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidFlowAnimation getFlowAnimation() {
        return this.flowAnimation;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        CompoundTag tankData = new CompoundTag();
        this.tank.writeToNBT(tankData);
        tag.m_128365_("Tank", (Tag)tankData);
        tag.m_128379_("Locked", this.locked);
        tag.m_128405_("WorkingState", this.workingState.ordinal());
        if (this.workingPartner != null) {
            tag.m_128356_("WorkingPartner", this.workingPartner.m_121878_());
        }
        tag.m_128365_("FluidLevel", (Tag)this.fluidLevel.writeNBT());
        if (clientPacket) {
            tag.m_128350_("CurrentLevel", this.getFluidLevel());
            if (!this.tank.isEmpty()) {
                CompoundTag fluidTag = new CompoundTag();
                this.tank.getFluid().writeToNBT(fluidTag);
                tag.m_128365_("ClientFluid", (Tag)fluidTag);
            }
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.m_128441_("Tank")) {
            if (this.tank == null) {
                this.initializeTank();
            }
            this.pendingTankData = tag.m_128469_("Tank");
            if (this.f_58857_ != null) {
                this.tank.readFromNBT(this.pendingTankData);
                this.pendingTankData = null;
                this.dataLoaded = true;
            }
        }
        this.locked = tag.m_128471_("Locked");
        if (tag.m_128441_("WorkingState")) {
            this.workingState = WorkingState.values()[tag.m_128451_("WorkingState")];
        }
        if (tag.m_128441_("WorkingPartner")) {
            this.workingPartner = BlockPos.m_122022_((long)tag.m_128454_("WorkingPartner"));
        }
        if (tag.m_128441_("FluidLevel")) {
            this.fluidLevel.readNBT(tag.m_128469_("FluidLevel"), clientPacket);
        }
        if (clientPacket) {
            if (tag.m_128441_("ClientFluid")) {
                FluidStack clientFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("ClientFluid"));
                if (!clientFluid.isEmpty()) {
                    this.tank.setFluid(clientFluid);
                    float newLevel = (float)clientFluid.getAmount() / (float)this.tank.getCapacity();
                    this.fluidLevel.startWithValue((double)newLevel);
                }
            } else if (tag.m_128441_("CurrentLevel")) {
                float currentLevel = tag.m_128457_("CurrentLevel");
                if (currentLevel == 0.0f && !this.tank.isEmpty()) {
                    this.tank.setFluid(FluidStack.EMPTY);
                }
                this.fluidLevel.startWithValue((double)currentLevel);
            }
            if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.flowAnimation == null) {
                this.flowAnimation = new FluidFlowAnimation();
            }
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidCapability.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    protected int getTransferRate() {
        return (Integer)CFCommonConfig.AQUEDUCT_TRANSFER_RATE.get();
    }

    public static enum WorkingState {
        IDLE,
        SOURCE,
        TARGET;

    }

    protected class AqueductFluidHandler
    implements IFluidHandler {
        protected AqueductFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return AbstractAqueductBlockEntity.this.tank.getFluid();
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return AbstractAqueductBlockEntity.this.tank.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (AbstractAqueductBlockEntity.this.locked || AbstractAqueductBlockEntity.this.isWorking()) {
                return 0;
            }
            int filled = AbstractAqueductBlockEntity.this.tank.fill(resource, action);
            if (filled > 0 && action.execute()) {
                AbstractAqueductBlockEntity.this.transferCooldown = 2;
            }
            return filled;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (AbstractAqueductBlockEntity.this.locked || AbstractAqueductBlockEntity.this.isWorking()) {
                return FluidStack.EMPTY;
            }
            return AbstractAqueductBlockEntity.this.tank.drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (AbstractAqueductBlockEntity.this.locked || AbstractAqueductBlockEntity.this.isWorking()) {
                return FluidStack.EMPTY;
            }
            return AbstractAqueductBlockEntity.this.tank.drain(maxDrain, action);
        }
    }
}

