/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid;

import com.adonis.fluid.config.CFCommonConfig;
import com.adonis.fluid.config.CFStress;
import com.adonis.fluid.networking.CFNetworking;
import com.adonis.fluid.registry.CFBlock;
import com.adonis.fluid.registry.CFBlockEntity;
import com.adonis.fluid.registry.CFFluid;
import com.adonis.fluid.registry.CFItem;
import com.adonis.fluid.registry.CFPartialModels;
import com.adonis.fluid.registry.CFTab;
import com.mojang.logging.LogUtils;
import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import java.util.Random;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="fluid")
public class CreateFluid {
    public static final String MODID = "fluid";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Random RANDOM = new Random();
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"fluid").setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    public static final CFStress STRESS_CONFIG = new CFStress("fluid");
    private static ForgeConfigSpec stressConfigSpec;

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MODID, path);
    }

    public CreateFluid() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        REGISTRATE.registerEventListeners(modEventBus);
        CFBlock.register();
        CFBlockEntity.register(modEventBus);
        CFItem.register(modEventBus);
        CFTab.register(modEventBus);
        CFFluid.register();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CFCommonConfig.CONFIG_SPEC);
        ForgeConfigSpec.Builder stressBuilder = new ForgeConfigSpec.Builder();
        STRESS_CONFIG.registerAll(stressBuilder);
        stressConfigSpec = stressBuilder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)stressConfigSpec, STRESS_CONFIG.getName() + ".toml");
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::processIMC);
        modEventBus.addListener(this::onModConfigEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CFCommonConfig.onLoad();
            CFPartialModels.init();
            BlockStressValues.IMPACTS.registerProvider(STRESS_CONFIG::getImpact);
            BlockStressValues.CAPACITIES.registerProvider(STRESS_CONFIG::getCapacity);
            CFNetworking.register();
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    private void onModConfigEvent(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == CFCommonConfig.CONFIG_SPEC) {
            if (event instanceof ModConfigEvent.Loading) {
                CFCommonConfig.onLoad();
            } else if (event instanceof ModConfigEvent.Reloading) {
                CFCommonConfig.onReload();
            }
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        CFCommonConfig.onLoad();
    }
}

