/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.frame;

import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public abstract class PortalFrameTester {
    protected HashSet<Block> VALID_FRAME = null;
    protected int foundPortalBlocks;
    public BlockPos lowerCorner;
    protected LevelAccessor world;

    public abstract PortalFrameTester init(LevelAccessor var1, BlockPos var2, Direction.Axis var3, Block ... var4);

    public abstract Optional<PortalFrameTester> getNewPortal(LevelAccessor var1, BlockPos var2, Direction.Axis var3, Block ... var4);

    public abstract Optional<PortalFrameTester> getOrEmpty(LevelAccessor var1, BlockPos var2, Predicate<PortalFrameTester> var3, Direction.Axis var4, Block ... var5);

    public abstract boolean isAlreadyLitPortalFrame();

    public abstract boolean isValidFrame();

    public abstract void lightPortal(Block var1);

    public abstract void createPortal(Level var1, BlockPos var2, BlockState var3, Direction.Axis var4);

    public abstract boolean isRequestedSize(int var1, int var2);

    public abstract BlockUtil.FoundRectangle getRectangle();

    public abstract Direction.Axis getAxis1();

    public abstract Direction.Axis getAxis2();

    public abstract BlockPos doesPortalFitAt(Level var1, BlockPos var2, Direction.Axis var3);

    public abstract Vec3 getEntityOffsetInPortal(BlockUtil.FoundRectangle var1, Entity var2, Direction.Axis var3);

    public abstract PortalInfo getTPTargetInPortal(BlockUtil.FoundRectangle var1, Direction.Axis var2, Vec3 var3, Entity var4);

    protected BlockPos getLowerCorner(BlockPos blockPos, Direction.Axis axis1, Direction.Axis axis2) {
        if (!PortalFrameTester.validStateInsidePortal(this.world.m_8055_(blockPos), this.VALID_FRAME)) {
            return null;
        }
        return this.getLimitForAxis(this.getLimitForAxis(blockPos, axis1), axis2);
    }

    protected BlockPos getLimitForAxis(BlockPos blockPos, Direction.Axis axis) {
        if (blockPos == null || axis == null) {
            return null;
        }
        int offset = 1;
        while (PortalFrameTester.validStateInsidePortal(this.world.m_8055_(blockPos.m_5487_(axis, -offset)), this.VALID_FRAME)) {
            if (++offset > 20) {
                return null;
            }
            if ((!axis.equals((Object)Direction.Axis.Y) || blockPos.m_123342_() - offset >= this.world.m_141937_()) && (axis.equals((Object)Direction.Axis.Y) || this.world.m_6857_().m_61937_(blockPos.m_5487_(axis, -offset)))) continue;
            return null;
        }
        return blockPos.m_5487_(axis, -(offset - 1));
    }

    protected int getSize(Direction.Axis axis, int minSize, int maxSize) {
        for (int i = 1; i <= maxSize; ++i) {
            BlockState blockState = this.world.m_8055_(this.lowerCorner.m_5487_(axis, i));
            if (PortalFrameTester.validStateInsidePortal(blockState, this.VALID_FRAME)) continue;
            if (!this.VALID_FRAME.contains(blockState.m_60734_())) break;
            return i >= minSize ? i : 0;
        }
        return 0;
    }

    protected boolean checkForValidFrame(Direction.Axis axis1, Direction.Axis axis2, int size1, int size2) {
        int i;
        BlockPos.MutableBlockPos checkPos = this.lowerCorner.m_122032_();
        for (i = 0; i < size1; ++i) {
            if (!this.VALID_FRAME.contains(this.world.m_8055_(checkPos.m_5487_(axis2, -1)).m_60734_()) || !this.VALID_FRAME.contains(this.world.m_8055_(checkPos.m_5487_(axis2, size2)).m_60734_())) {
                return false;
            }
            checkPos = checkPos.m_5487_(axis1, 1);
        }
        checkPos = this.lowerCorner.m_122032_();
        for (i = 0; i < size2; ++i) {
            if (!this.VALID_FRAME.contains(this.world.m_8055_(checkPos.m_5487_(axis1, -1)).m_60734_()) || !this.VALID_FRAME.contains(this.world.m_8055_(checkPos.m_5487_(axis1, size1)).m_60734_())) {
                return false;
            }
            checkPos = checkPos.m_5487_(axis2, 1);
        }
        return true;
    }

    protected void countExistingPortalBlocks(Direction.Axis axis1, Direction.Axis axis2, int size1, int size2) {
        for (int i = 0; i < size1; ++i) {
            for (int j = 0; j < size2; ++j) {
                if (!CustomPortalHelper.isInstanceOfCustomPortal(this.world.m_8055_(this.lowerCorner.m_5487_(axis1, i).m_5487_(axis2, j)))) continue;
                ++this.foundPortalBlocks;
            }
        }
    }

    public static boolean validStateInsidePortal(BlockState blockState, HashSet<Block> foundations) {
        PortalIgnitionSource ignitionSource = PortalIgnitionSource.FIRE;
        for (Block block : foundations) {
            PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(block);
            if (link == null) continue;
            ignitionSource = link.portalIgnitionSource;
            break;
        }
        if (blockState.m_60795_() || CustomPortalHelper.isInstanceOfCustomPortal(blockState)) {
            return true;
        }
        if (ignitionSource == PortalIgnitionSource.FIRE) {
            return blockState.m_204336_(BlockTags.f_13076_);
        }
        if (ignitionSource.isWater()) {
            return blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        }
        if (ignitionSource.isLava()) {
            return blockState.m_60819_().m_205070_(FluidTags.f_13132_);
        }
        if (ignitionSource.sourceType == PortalIgnitionSource.SourceType.FLUID) {
            return BuiltInRegistries.f_257020_.m_7981_((Object)blockState.m_60819_().m_76152_()).equals((Object)ignitionSource.ignitionSourceID);
        }
        return false;
    }

    @FunctionalInterface
    public static interface PortalFrameTesterFactory {
        public PortalFrameTester createInstanceOfPortalFrameTester();
    }
}

