/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.networking;

import java.util.Optional;
import java.util.function.Supplier;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.PerWorldPortals;
import net.kyrptonaught.customportalapi.networking.ForcePlacePortalPacket;
import net.kyrptonaught.customportalapi.networking.NetworkManager;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public record PortalRegistrySyncPacket(PortalLink link) {
    public static void sendForcePacket(ServerPlayer player, BlockPos pos) {
        NetworkManager.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ForcePlacePortalPacket(pos));
    }

    public static PortalRegistrySyncPacket decode(FriendlyByteBuf buf) {
        return new PortalRegistrySyncPacket(new PortalLink(buf.m_130281_(), buf.m_130281_(), buf.readInt()));
    }

    public static void encode(PortalRegistrySyncPacket packet, FriendlyByteBuf buf) {
        buf.m_130085_(packet.link().block).m_130085_(packet.link().dimID).writeInt(packet.link().colorID);
    }

    public static void handle(PortalRegistrySyncPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        PerWorldPortals.registerWorldPortal(packet.link());
        contextSupplier.get().setPacketHandled(true);
    }

    public static void register(SimpleChannel channel, Integer id) {
        channel.registerMessage(id.intValue(), PortalRegistrySyncPacket.class, PortalRegistrySyncPacket::encode, PortalRegistrySyncPacket::decode, PortalRegistrySyncPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static void registerSyncOnPlayerJoin() {
        MinecraftForge.EVENT_BUS.addListener(PortalRegistrySyncPacket::onPlayerJoinWorld);
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            for (PortalLink link : CustomPortalApiRegistry.getAllPortalLinks()) {
                NetworkManager.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PortalRegistrySyncPacket(link));
            }
        }
    }
}

