/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.mixin.client;

import com.mojang.authlib.GameProfile;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.interfaces.ClientPlayerInColoredPortal;
import net.kyrptonaught.customportalapi.interfaces.EntityInCustomPortal;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LocalPlayer.class})
public abstract class ClientPlayerMixin
extends Player
implements EntityInCustomPortal,
ClientPlayerInColoredPortal {
    @Shadow
    public float f_108589_;
    @Shadow
    public float f_108590_;
    @Shadow
    @Final
    protected Minecraft f_108619_;
    int portalColor;

    public ClientPlayerMixin(Level world, BlockPos pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Shadow
    public abstract void m_6915_();

    @Override
    public void setLastUsedPortalColor(int color) {
        this.portalColor = color;
    }

    @Override
    public int getLastUsedPortalColor() {
        return this.portalColor;
    }

    @Inject(method={"updateNausea"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectCustomNausea(CallbackInfo ci) {
        if (this.f_19817_) {
            this.setLastUsedPortalColor(-1);
        } else if (this.getTimeInPortal() > 0) {
            PortalLink link;
            int previousColor = this.getLastUsedPortalColor();
            PortalLink portalLink = link = this.getInPortalPos() != null ? CustomPortalApiRegistry.getPortalLinkFromBase(CustomPortalHelper.getPortalBase(this.m_9236_(), this.getInPortalPos())) : null;
            if (link != null) {
                this.setLastUsedPortalColor(link.colorID);
            }
            this.updateCustomNausea(previousColor);
            ci.cancel();
        }
    }

    @Unique
    private void updateCustomNausea(int previousColor) {
        this.f_108590_ = this.f_108589_;
        if (this.getTimeInPortal() > 0) {
            if (this.f_108619_.f_91080_ != null && !this.f_108619_.f_91080_.m_7043_()) {
                if (this.f_108619_.f_91080_ instanceof AbstractContainerScreen) {
                    this.m_6915_();
                }
                this.f_108619_.m_91152_(null);
            }
            if (this.f_108589_ == 0.0f && previousColor != -999) {
                PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(CustomPortalHelper.getPortalBase(this.m_9236_(), this.getInPortalPos()));
                if (link != null && link.getInPortalAmbienceEvent().hasEvent()) {
                    this.f_108619_.m_91106_().m_120367_((SoundInstance)link.getInPortalAmbienceEvent().execute(this).getInstance());
                } else {
                    this.f_108619_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119766_((SoundEvent)SoundEvents.f_12288_, (float)(this.f_19796_.m_188501_() * 0.4f + 0.8f), (float)0.25f));
                }
            }
            this.f_108589_ += 0.0125f;
            if (this.f_108589_ >= 1.0f) {
                this.f_108589_ = 1.0f;
            }
        } else if (this.m_21023_(MobEffects.f_19604_) && this.m_21124_(MobEffects.f_19604_).m_19557_() > 60) {
            this.f_108589_ += 0.006666667f;
            if (this.f_108589_ > 1.0f) {
                this.f_108589_ = 1.0f;
            }
        } else {
            if (this.f_108589_ > 0.0f) {
                this.f_108589_ -= 0.05f;
            }
            if (this.f_108589_ < 0.0f) {
                this.f_108589_ = 0.0f;
            }
        }
    }
}

