/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.me.service.EnergyService;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public final class SubnetPlots {
    private static final AEItemKey STICK = AEItemKey.of((ItemLike)Items.f_42398_);

    private SubnetPlots() {
    }

    @TestPlot(value="subnet")
    public static void subnet(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.creativeEnergyCell(origin.m_7495_());
        plot.cable(origin).part(Direction.NORTH, AEParts.TERMINAL).part(Direction.SOUTH, AEParts.STORAGE_BUS).part(Direction.EAST, AEParts.QUARTZ_FIBER);
        plot.cable(origin.m_122029_());
        plot.cable(origin.m_122029_().m_122019_());
        plot.cable(origin.m_122019_()).part(Direction.NORTH, AEParts.INTERFACE);
        plot.storageDrive(origin.m_122019_().m_7494_());
        BlockPos subNetPos = origin.m_122019_();
        BlockPos mainNetPos = origin;
        plot.test(helper -> helper.m_177425_().m_177552_(() -> helper.getGrid(subNetPos)).m_177552_(() -> helper.getGrid(mainNetPos)).m_177562_(() -> {
            IGrid mainGrid = helper.getGrid(mainNetPos);
            IStorageService storageService = mainGrid.getService(IStorageService.class);
            long inserted = storageService.getInventory().insert(STICK, 1L, Actionable.MODULATE, null);
            helper.check(inserted == 1L, "inserted != 1: " + inserted, mainNetPos);
            KeyCounter inventory = storageService.getInventory().getAvailableStacks();
            helper.check(inventory.get(STICK) == 1L, "stick not present", mainNetPos);
        }).m_177544_(10).m_177562_(() -> {
            IGrid mainGrid = helper.getGrid(mainNetPos);
            IStorageService storageService = mainGrid.getService(IStorageService.class);
            KeyCounter inventory = storageService.getInventory().getAvailableStacks();
            helper.check(inventory.get(STICK) == 1L, "stick not present in tick #10", mainNetPos);
            long extracted = storageService.getInventory().extract(STICK, 1L, Actionable.MODULATE, null);
            helper.check(extracted == 1L, "unable to extract", mainNetPos);
        }).m_177543_());
    }

    @TestPlot(value="energy_overlay")
    public static void energy_overlay(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.cable(origin).part(Direction.EAST, AEParts.QUARTZ_FIBER);
        plot.block(origin.m_122029_(), AEBlocks.DENSE_ENERGY_CELL);
        plot.block(origin.m_122024_(), AEBlocks.ENERGY_CELL);
        plot.cable(origin.m_122024_().m_122024_()).part(Direction.EAST, AEParts.QUARTZ_FIBER);
        plot.test(helper -> helper.m_177425_().m_177552_(() -> helper.getGrid(origin)).m_177562_(() -> {
            IGrid denseCellGrid = helper.getGrid(origin.m_122029_());
            IGrid cellGrid = helper.getGrid(origin.m_122024_());
            IGrid noCellGrid = helper.getGrid(origin.m_122024_().m_122024_());
            EnergyService denseCellService = (EnergyService)denseCellGrid.getService(IEnergyService.class);
            EnergyService cellService = (EnergyService)cellGrid.getService(IEnergyService.class);
            EnergyService noCellService = (EnergyService)noCellGrid.getService(IEnergyService.class);
            denseCellService.injectPower(1.0, Actionable.MODULATE);
            helper.check(SubnetPlots.getLocalStoredPower(denseCellService) == 1.0, "expect power = 1", origin.m_122029_());
            cellService.injectPower(1.0, Actionable.MODULATE);
            helper.check(SubnetPlots.getLocalStoredPower(denseCellService) == 2.0, "expect power = 2", origin.m_122029_());
            noCellService.injectPower(1.0, Actionable.MODULATE);
            helper.check(SubnetPlots.getLocalStoredPower(denseCellService) == 3.0, "expect power = 3", origin.m_122029_());
            denseCellService.extractAEPower(1.0, Actionable.MODULATE, PowerMultiplier.ONE);
            helper.check(SubnetPlots.getLocalStoredPower(denseCellService) == 2.0, "expect power = 2", origin.m_122029_());
            cellService.extractAEPower(1.0, Actionable.MODULATE, PowerMultiplier.ONE);
            helper.check(SubnetPlots.getLocalStoredPower(denseCellService) == 1.0, "expect power = 1", origin.m_122029_());
            noCellService.extractAEPower(1.0, Actionable.MODULATE, PowerMultiplier.ONE);
            helper.check(SubnetPlots.getLocalStoredPower(denseCellService) == 0.0, "expect power = 0", origin.m_122029_());
        }).m_177543_());
    }

    @TestPlot(value="multi_storage_bus")
    public static void multi_storage_bus(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.storageDrive(origin.m_122024_());
        plot.block(origin, AEBlocks.INTERFACE);
        plot.block(origin.m_122029_(), AEBlocks.INTERFACE);
        plot.creativeEnergyCell(origin.m_122029_().m_122029_());
        BlockPos subnetOrigin = origin.m_122012_();
        plot.cable(subnetOrigin).part(Direction.SOUTH, AEParts.STORAGE_BUS, bus -> bus.getConfig().addFilter((ItemLike)Items.f_42313_));
        plot.cable(subnetOrigin.m_122029_()).part(Direction.SOUTH, AEParts.STORAGE_BUS, bus -> bus.getConfig().addFilter((ItemLike)Items.f_42310_));
        plot.cable(subnetOrigin.m_122029_().m_122029_()).part(Direction.SOUTH, AEParts.QUARTZ_FIBER).part(Direction.NORTH, AEParts.TERMINAL);
        plot.test(helper -> helper.m_177425_().m_177552_(() -> {
            helper.getGrid(origin);
            helper.getGrid(subnetOrigin);
        }).m_177562_(() -> {
            IGrid mainGrid = helper.getGrid(origin);
            MEStorage mainInv = mainGrid.getStorageService().getInventory();
            mainInv.insert(AEItemKey.of((ItemLike)Items.f_42313_), 64L, Actionable.MODULATE, IActionSource.empty());
            mainInv.insert(AEItemKey.of((ItemLike)Items.f_42310_), 64L, Actionable.MODULATE, IActionSource.empty());
        }).m_177544_(1).m_177562_(() -> {
            IGrid subnet = helper.getGrid(subnetOrigin);
            helper.assertContains(subnet, Items.f_42313_);
            helper.assertContains(subnet, Items.f_42310_);
        }).m_177543_());
    }

    private static double getLocalStoredPower(EnergyService service) {
        service.refreshPower();
        return service.getStoredPower();
    }
}

