/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.entropy.EntropyRecipeSerializer;
import appeng.recipes.entropy.StateApplier;
import appeng.recipes.entropy.StateMatcher;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class EntropyRecipeBuilder {
    private ResourceLocation id;
    private EntropyMode mode;
    private Block inputBlock;
    private List<StateMatcher> inputBlockMatchers = Collections.emptyList();
    private Fluid inputFluid;
    private List<StateMatcher> inputFluidMatchers = Collections.emptyList();
    private Block outputBlock;
    private List<StateApplier<?>> outputBlockStateAppliers = Collections.emptyList();
    private boolean outputBlockKeep;
    private Fluid outputFluid;
    private List<StateApplier<?>> outputFluidStateAppliers = Collections.emptyList();
    private boolean outputFluidKeep;
    private List<ItemStack> drops = Collections.emptyList();

    public static EntropyRecipeBuilder cool(ResourceLocation id) {
        return new EntropyRecipeBuilder().setId(id).setMode(EntropyMode.COOL);
    }

    public static EntropyRecipeBuilder heat(ResourceLocation id) {
        return new EntropyRecipeBuilder().setId(id).setMode(EntropyMode.HEAT);
    }

    public EntropyRecipeBuilder setId(ResourceLocation id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0);
        this.id = id;
        return this;
    }

    public EntropyRecipeBuilder setMode(EntropyMode mode) {
        this.mode = Objects.requireNonNull(mode, "mode must not be null");
        return this;
    }

    public EntropyRecipeBuilder setInputBlock(Block inputBlock) {
        this.inputBlock = Objects.requireNonNull(inputBlock, "inputBlock must not be null");
        return this;
    }

    public EntropyRecipeBuilder setInputFluid(Fluid inputFluid) {
        this.inputFluid = Objects.requireNonNull(inputFluid, "inputFluid must not be null");
        return this;
    }

    public EntropyRecipeBuilder setOutputBlock(Block outputBlock) {
        this.outputBlock = Objects.requireNonNull(outputBlock, "outputBlock must not be null");
        return this;
    }

    public EntropyRecipeBuilder setOutputBlockKeep(boolean outputBlockKeep) {
        this.outputBlockKeep = outputBlockKeep;
        return this;
    }

    public EntropyRecipeBuilder setOutputFluid(Fluid outputFluid) {
        this.outputFluid = Objects.requireNonNull(outputFluid, "outputFluid must not be null");
        return this;
    }

    public EntropyRecipeBuilder setOutputFluidKeep(boolean outputFluidKeep) {
        this.outputFluidKeep = outputFluidKeep;
        return this;
    }

    public EntropyRecipeBuilder setDrops(List<ItemStack> drops) {
        Preconditions.checkArgument((!drops.isEmpty() ? 1 : 0) != 0, (Object)"drops needs to be a non empty list when set");
        this.drops = drops;
        return this;
    }

    public EntropyRecipeBuilder setDrops(ItemStack ... drops) {
        return this.setDrops(Arrays.asList(drops));
    }

    public EntropyRecipeBuilder addBlockStateMatcher(StateMatcher matcher) {
        Preconditions.checkState((this.inputBlock != null ? 1 : 0) != 0, (Object)"Can only add appliers when an input block is present.");
        if (this.inputBlockMatchers.isEmpty()) {
            this.inputBlockMatchers = new ArrayList<StateMatcher>();
        }
        this.inputBlockMatchers.add(matcher);
        return this;
    }

    public EntropyRecipeBuilder addFluidStateMatcher(StateMatcher matcher) {
        Preconditions.checkState((this.inputFluid != null ? 1 : 0) != 0, (Object)"Can only add appliers when an input fluid is present.");
        if (this.inputFluidMatchers.isEmpty()) {
            this.inputFluidMatchers = new ArrayList<StateMatcher>();
        }
        this.inputFluidMatchers.add(matcher);
        return this;
    }

    public EntropyRecipeBuilder addBlockStateAppliers(StateApplier<?> applier) {
        Preconditions.checkState((this.outputBlock != null ? 1 : 0) != 0, (Object)"Can only add appliers when an output block is present.");
        if (this.outputBlockStateAppliers.isEmpty()) {
            this.outputBlockStateAppliers = new ArrayList();
        }
        this.outputBlockStateAppliers.add(applier);
        return this;
    }

    public EntropyRecipeBuilder addFluidStateAppliers(StateApplier<?> applier) {
        Preconditions.checkState((this.outputFluid != null ? 1 : 0) != 0, (Object)"Can only add appliers when an output fluid is present.");
        if (this.outputFluidStateAppliers.isEmpty()) {
            this.outputFluidStateAppliers = new ArrayList();
        }
        this.outputFluidStateAppliers.add(applier);
        return this;
    }

    public EntropyRecipe build() {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0);
        Preconditions.checkState((this.mode != null ? 1 : 0) != 0);
        Preconditions.checkState((this.inputBlock != null || this.inputFluid != null ? 1 : 0) != 0, (Object)"Either inputBlock or inputFluid needs to be not null");
        return new EntropyRecipe(this.id, this.mode, this.inputBlock, this.inputBlockMatchers, this.inputFluid, this.inputFluidMatchers, this.outputBlock, this.outputBlockStateAppliers, this.outputBlockKeep, this.outputFluid, this.outputFluidStateAppliers, this.outputFluidKeep, this.drops);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Result());
    }

    private class Result
    implements FinishedRecipe {
        private Result() {
        }

        public void m_7917_(JsonObject json) {
            EntropyRecipeSerializer.INSTANCE.toJson(EntropyRecipeBuilder.this.build(), json);
        }

        public ResourceLocation m_6445_() {
            return EntropyRecipeBuilder.this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return EntropyRecipeSerializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

