/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.storage.StorageHelper;
import appeng.parts.automation.HandlerStrategy;
import appeng.util.BlockApiCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageExportStrategy<C, S>
implements StackExportStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageExportStrategy.class);
    private final BlockApiCache<C> apiCache;
    private final Direction fromSide;
    private final HandlerStrategy<C, S> handlerStrategy;

    protected StorageExportStrategy(Capability<C> apiLookup, HandlerStrategy<C, S> handlerStrategy, ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.handlerStrategy = handlerStrategy;
        this.apiCache = BlockApiCache.create(apiLookup, level, fromPos);
        this.fromSide = fromSide;
    }

    @Override
    public long transfer(StackTransferContext context, AEKey what, long amount) {
        if (!this.handlerStrategy.isSupported(what)) {
            return 0L;
        }
        C adjacentStorage = this.apiCache.find(this.fromSide);
        if (adjacentStorage == null) {
            return 0L;
        }
        IStorageService inv = context.getInternalStorage();
        long extracted = StorageHelper.poweredExtraction(context.getEnergySource(), inv.getInventory(), what, amount, context.getActionSource(), Actionable.SIMULATE);
        long wasInserted = this.handlerStrategy.insert(adjacentStorage, what, extracted, Actionable.SIMULATE);
        if (wasInserted > 0L && (wasInserted = this.handlerStrategy.insert(adjacentStorage, what, extracted = StorageHelper.poweredExtraction(context.getEnergySource(), inv.getInventory(), what, wasInserted, context.getActionSource(), Actionable.MODULATE), Actionable.MODULATE)) < extracted) {
            long leftover = extracted - wasInserted;
            if ((leftover -= inv.getInventory().insert(what, leftover, Actionable.MODULATE, context.getActionSource())) > 0L) {
                LOGGER.error("Storage export: adjacent block unexpectedly refused insert, voided {}x{}", (Object)leftover, (Object)what);
            }
        }
        return wasInserted;
    }

    @Override
    public long push(AEKey what, long amount, Actionable mode) {
        if (!this.handlerStrategy.isSupported(what)) {
            return 0L;
        }
        C adjacentStorage = this.apiCache.find(this.fromSide);
        if (adjacentStorage == null) {
            return 0L;
        }
        return this.handlerStrategy.insert(adjacentStorage, what, amount, mode);
    }

    public static StackExportStrategy createItem(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        return new StorageExportStrategy<IItemHandler, ItemStack>(ForgeCapabilities.ITEM_HANDLER, HandlerStrategy.ITEMS, level, fromPos, fromSide);
    }

    public static StackExportStrategy createFluid(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        return new StorageExportStrategy<IFluidHandler, FluidStack>(ForgeCapabilities.FLUID_HANDLER, HandlerStrategy.FLUIDS, level, fromPos, fromSide);
    }
}

