/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.networking.GridServicesInternal;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.events.GridEvent;
import appeng.core.AELog;
import appeng.hooks.ticking.TickHandler;
import appeng.me.GridEventBus;
import appeng.me.GridNode;
import appeng.me.helpers.GridServiceContainer;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.CrashReportCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Grid
implements IGrid {
    private static final List<IGridNode> ITERATION_BUFFER = new ArrayList<IGridNode>();
    private static int nextSerial = 0;
    private final SetMultimap<Class<?>, IGridNode> machines = MultimapBuilder.hashKeys().hashSetValues().build();
    private final GridServiceContainer services;
    @Nullable
    private GridNode pivot;
    private int priority;
    private final int serialNumber = nextSerial++;

    public static Grid create(GridNode center) {
        Grid grid = new Grid(center);
        TickHandler.instance().addNetwork(grid);
        center.setGrid(grid);
        AELog.grid("Created grid %s with center %s", grid, center);
        return grid;
    }

    private Grid(GridNode center) {
        this.pivot = Objects.requireNonNull(center);
        this.services = GridServicesInternal.createServices(this);
    }

    int getPriority() {
        return this.priority;
    }

    @Override
    public int size() {
        return this.machines.size();
    }

    void remove(GridNode gridNode) {
        for (IGridServiceProvider c : this.services.services().values()) {
            c.removeNode(gridNode);
        }
        Class<?> machineClass = gridNode.getOwner().getClass();
        this.machines.remove(machineClass, (Object)gridNode);
        if (this.pivot == gridNode) {
            Iterator nodesIt = this.machines.values().iterator();
            if (nodesIt.hasNext()) {
                this.pivot = (GridNode)nodesIt.next();
            } else {
                this.pivot = null;
                TickHandler.instance().removeNetwork(this);
                AELog.grid("Removed grid %s", this);
            }
        }
    }

    void add(GridNode gridNode, @Nullable CompoundTag savedData) {
        this.machines.put(gridNode.getOwner().getClass(), (Object)gridNode);
        for (IGridServiceProvider service : this.services.services().values()) {
            service.addNode(gridNode, savedData);
        }
    }

    void saveNodeData(GridNode gridNode, CompoundTag savedData) {
        for (IGridServiceProvider service : this.services.services().values()) {
            service.saveNodeData(gridNode, savedData);
        }
    }

    @Override
    public <C extends IGridService> C getService(Class<C> iface) {
        IGridServiceProvider service = this.services.services().get(iface);
        if (service == null) {
            throw new IllegalArgumentException("Service " + String.valueOf(iface) + " is not registered");
        }
        return (C)((IGridService)((Object)service));
    }

    @Override
    public <T extends GridEvent> T postEvent(T ev) {
        GridEventBus.postEvent(this, ev);
        return ev;
    }

    @Override
    public Iterable<Class<?>> getMachineClasses() {
        return this.machines.keySet();
    }

    @Override
    public Iterable<IGridNode> getMachineNodes(Class<?> machineClass) {
        return this.machines.get(machineClass);
    }

    @Override
    public <T> Set<T> getMachines(Class<T> machineClass) {
        Set nodes = this.machines.get(machineClass);
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (IGridNode node : nodes) {
            Object logicalHost = node.getOwner();
            if (!machineClass.isInstance(logicalHost)) continue;
            resultBuilder.add(machineClass.cast(logicalHost));
        }
        return resultBuilder.build();
    }

    @Override
    public <T> Set<T> getActiveMachines(Class<T> machineClass) {
        Set nodes = this.machines.get(machineClass);
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (IGridNode node : nodes) {
            Object logicalHost = node.getOwner();
            if (!machineClass.isInstance(logicalHost) || !node.isActive()) continue;
            resultBuilder.add(machineClass.cast(logicalHost));
        }
        return resultBuilder.build();
    }

    public Collection<IGridNode> getNodes() {
        return this.machines.values();
    }

    @Override
    public boolean isEmpty() {
        return this.pivot == null;
    }

    @Override
    public IGridNode getPivot() {
        return this.pivot;
    }

    void setPivot(GridNode pivot) {
        this.pivot = pivot;
    }

    public void onServerStartTick() {
        if (this.pivot == null) {
            return;
        }
        for (IGridServiceProvider gc : this.services.serverStartTickServices()) {
            gc.onServerStartTick();
        }
    }

    public void onLevelStartTick(Level level) {
        if (this.pivot == null) {
            return;
        }
        for (IGridServiceProvider gc : this.services.levelStartTickServices()) {
            gc.onLevelStartTick(level);
        }
    }

    public void onLevelEndTick(Level level) {
        if (this.pivot == null) {
            return;
        }
        for (IGridServiceProvider gc : this.services.levelEndtickServices()) {
            gc.onLevelEndTick(level);
        }
    }

    public void onServerEndTick() {
        if (this.pivot == null) {
            return;
        }
        for (IGridServiceProvider gc : this.services.serverEndTickServices()) {
            gc.onServerEndTick();
        }
    }

    public void setImportantFlag(int i, boolean publicHasPower) {
        int flag = 1 << i;
        this.priority = this.priority & ~flag | (publicHasPower ? flag : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAllNodes(IGridNodeListener.State state) {
        if (!ITERATION_BUFFER.isEmpty()) {
            throw new IllegalStateException("Recursively trying to notify all nodes is not allowed");
        }
        try {
            ITERATION_BUFFER.addAll((Collection<IGridNode>)this.getNodes());
            for (IGridNode node : ITERATION_BUFFER) {
                ((GridNode)node).notifyStatusChange(state);
            }
        }
        finally {
            ITERATION_BUFFER.clear();
        }
    }

    public void fillCrashReportCategory(CrashReportCategory category) {
        category.m_128159_("Nodes", (Object)this.machines.size());
        category.m_128159_("Serial number", (Object)this.serialNumber);
        if (AELog.isGridLogEnabled()) {
            category.m_128159_("All GridNodes", (Object)this.machines.values().stream().map(Object::toString).collect(Collectors.joining(";")));
        }
        if (this.pivot != null) {
            this.pivot.fillCrashReportCategory(category);
        }
    }

    public String toString() {
        return "Grid #" + this.serialNumber;
    }
}

