/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.emi;

import appeng.api.integrations.emi.EmiStackConverter;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import dev.emi.emi.api.forge.ForgeEmiStack;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

class EmiFluidStackConverter
implements EmiStackConverter {
    EmiFluidStackConverter() {
    }

    @Override
    public Class<?> getKeyType() {
        return Fluid.class;
    }

    @Override
    @Nullable
    public EmiStack toEmiStack(GenericStack stack) {
        AEKey aEKey = stack.what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            return ForgeEmiStack.of((FluidStack)fluidKey.toStack(1)).setAmount(stack.amount());
        }
        return null;
    }

    @Override
    @Nullable
    public GenericStack toGenericStack(EmiStack stack) {
        Fluid fluid = (Fluid)stack.getKeyOfType(Fluid.class);
        if (fluid != null && fluid != Fluids.f_76191_) {
            FluidStack fluidStack = new FluidStack(fluid.m_76145_().m_76152_(), 1, stack.getNbt());
            AEFluidKey fluidKey = AEFluidKey.of(fluidStack);
            return new GenericStack(fluidKey, stack.getAmount());
        }
        return null;
    }
}

