/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.utils.gui;

public class PositionPoint {
    private int x;
    private int y;
    private int offsetX;
    private int offsetY;
    private int absoluteX;
    private int absoluteY;

    public PositionPoint() {
        this(0, 0, 0, 0);
    }

    public PositionPoint(int x, int y) {
        this(x, y, 0, 0);
    }

    public PositionPoint(int x, int y, int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.x = x;
        this.y = y;
        this.recalculateAbsolutePosition();
    }

    public int getAbsoluteX() {
        return this.absoluteX;
    }

    public int getAbsoluteY() {
        return this.absoluteY;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
        this.recalculateAbsolutePosition();
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
        this.recalculateAbsolutePosition();
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
        this.recalculateAbsolutePosition();
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        this.recalculateAbsolutePosition();
    }

    public void setOffset(PositionPoint positionPoint) {
        this.setOffsetX(positionPoint.getX());
        this.setOffsetY(positionPoint.getY());
    }

    private void recalculateAbsolutePosition() {
        this.absoluteX = Math.max(0, this.offsetX + this.x);
        this.absoluteY = Math.max(0, this.offsetY + this.y);
    }

    public String toString() {
        return "PositionPoint{x:" + this.x + ", y:" + this.y + ", offsetX:" + this.offsetX + ", offsetY:" + this.offsetY + "}";
    }
}

