/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.utils.gui;

import com.mojang.blaze3d.platform.Window;
import de.markusbordihn.advancementstracker.utils.gui.PositionPoint;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PositionManager {
    protected static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private static final int HOTBAR_RIGHT = 90;
    private static final int HOTBAR_LEFT = -90;
    private static final int SAFE_AREA = 25;
    private PositionPoint position = new PositionPoint();
    private BasePosition basePosition = BasePosition.MIDDLE_RIGHT;
    private Window window;
    private int guiScaledHeight;
    private int guiScaledWidth;
    private int height = 100;
    private int width = 100;
    private int defaultHeight = 100;
    private int defaultWidth = 100;
    private int windowHeight = 400;
    private int windowWidth = 640;

    public PositionManager() {
    }

    public PositionManager(Minecraft minecraft) {
        this.setInstance(minecraft);
    }

    public void setInstance(Minecraft minecraft) {
        this.window = minecraft.m_91268_();
        this.updateWindow();
    }

    public PositionPoint getTopLeft() {
        return new PositionPoint(0, 0);
    }

    public PositionPoint getTopRight() {
        return new PositionPoint(this.guiScaledWidth - this.getWidthOrDefault(), 0);
    }

    public PositionPoint getBottomLeft() {
        return new PositionPoint(0, this.guiScaledHeight - this.getHeightOrDefault());
    }

    public PositionPoint getBottomRight() {
        return new PositionPoint(this.guiScaledWidth - this.getWidthOrDefault(), this.guiScaledHeight - this.getHeightOrDefault());
    }

    public PositionPoint getMiddleLeft() {
        return new PositionPoint(0, this.guiScaledHeight / 2 - this.getHeightOrDefault() / 2);
    }

    public PositionPoint getMiddleRight() {
        return new PositionPoint(this.guiScaledWidth - this.width, this.guiScaledHeight / 2 - this.getHeightOrDefault() / 2);
    }

    public PositionPoint getHotbarLeft() {
        return new PositionPoint(this.guiScaledWidth / 2 + -90 - this.getWidthOrDefault(), this.guiScaledHeight - this.getHeightOrDefault());
    }

    public PositionPoint getHotbarRight() {
        return new PositionPoint(this.guiScaledWidth / 2 + 90, this.guiScaledHeight - this.getHeightOrDefault());
    }

    public void setBasePosition(BasePosition basePosition) {
        this.basePosition = basePosition;
        this.updateBasePosition();
    }

    public void updateBasePosition() {
        switch (this.basePosition) {
            case TOP_LEFT: {
                this.position.setOffset(this.getTopLeft());
                break;
            }
            case TOP_RIGHT: {
                this.position.setOffset(this.getTopRight());
                break;
            }
            case BOTTOM_LEFT: {
                this.position.setOffset(this.getBottomLeft());
                break;
            }
            case BOTTOM_RIGHT: {
                this.position.setOffset(this.getBottomRight());
                break;
            }
            case MIDDLE_LEFT: {
                this.position.setOffset(this.getMiddleLeft());
                break;
            }
            default: {
                this.position.setOffset(this.getMiddleRight());
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public PositionPoint getPosition() {
        return this.position;
    }

    public int getPositionX() {
        return this.position.getAbsoluteX();
    }

    public void setPositionX(int x) {
        this.position.setX(Math.min(x, this.guiScaledWidth - this.getWidthOrDefault() - 25));
    }

    public int getPositionY() {
        return this.position.getAbsoluteY();
    }

    public void setPositionY(int y) {
        this.position.setY(Math.min(y, this.guiScaledHeight - this.getHeightOrDefault() - 25));
    }

    public int getPositionXWidth() {
        return this.position.getAbsoluteX() + this.width;
    }

    public int getPositionYHeight() {
        return this.position.getAbsoluteY() + this.height;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public int getWindowHeightScaled() {
        return this.guiScaledHeight;
    }

    public int getWindowWidthScaled() {
        return this.guiScaledWidth;
    }

    public void setPositionPoint(PositionPoint position) {
        this.position = position;
    }

    public void updateWindow() {
        if (this.window == null) {
            return;
        }
        int currentGuiScaledWidth = this.window.m_85445_();
        int currentGuiScaleHeight = this.window.m_85446_();
        if (this.guiScaledWidth == currentGuiScaledWidth && this.guiScaledHeight == currentGuiScaleHeight) {
            return;
        }
        this.guiScaledHeight = currentGuiScaleHeight;
        this.guiScaledWidth = currentGuiScaledWidth;
        this.windowHeight = this.window.m_85442_();
        this.windowWidth = this.window.m_85441_();
        this.updateBasePosition();
    }

    private int getWidthOrDefault() {
        return this.width == 0 ? this.defaultWidth : this.width;
    }

    private int getHeightOrDefault() {
        return this.height == 0 ? this.defaultHeight : this.height;
    }

    public static enum BasePosition {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        MIDDLE_LEFT,
        MIDDLE_RIGHT,
        TOP_LEFT,
        TOP_RIGHT;

    }
}

