/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.advancementstracker.Constants;
import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntry;
import de.markusbordihn.advancementstracker.client.advancements.AdvancementsManager;
import de.markusbordihn.advancementstracker.client.advancements.TrackedAdvancementsManager;
import de.markusbordihn.advancementstracker.client.keymapping.ModKeyMapping;
import de.markusbordihn.advancementstracker.config.ClientConfig;
import de.markusbordihn.advancementstracker.utils.gui.PositionManager;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class AdvancementsTrackerWidget {
    protected static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private static final ClientConfig.Config CLIENT = ClientConfig.CLIENT;
    private static final int BACKGROUND_COLOR = 0x70000000;
    private static final String HOT_KEY_ADVANCEMENT_TRACKER = "advancements_tracker.advancementsWidget.hotkeyAdvancementTracker";
    private static final String HOT_KEY_ADVANCEMENT_OVERVIEW = "advancements_tracker.advancementsWidget.hotkeyAdvancementOverview";
    private static final MutableComponent ADVANCEMENT_TITLE_TEXT = Component.m_237113_((String)"\u2611 Advancements Tracker");
    private static MutableComponent noAdvancementsText = Component.m_237115_((String)"advancements_tracker.advancementsWidget.noAdvancements").m_7220_(ModKeyMapping.KEY_SHOW_WIDGET.m_90863_()).m_7220_((Component)Component.m_237110_((String)"advancements_tracker.advancementsWidget.hotkeyAdvancementTracker", (Object[])new Object[]{ModKeyMapping.KEY_SHOW_WIDGET.m_90863_()}).m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.WHITE);
    private static MutableComponent noTrackedAdvancementsText = Component.m_237115_((String)"advancements_tracker.advancementsWidget.noTrackedAdvancements").m_7220_((Component)Component.m_237110_((String)"advancements_tracker.advancementsWidget.hotkeyAdvancementOverview", (Object[])new Object[]{ModKeyMapping.KEY_SHOW_OVERVIEW.m_90863_()}).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237110_((String)"advancements_tracker.advancementsWidget.hotkeyAdvancementTracker", (Object[])new Object[]{ModKeyMapping.KEY_SHOW_WIDGET.m_90863_()}).m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.WHITE);
    private static PositionManager positionManager = new PositionManager();
    private static Set<AdvancementEntry> trackedAdvancements;
    private static boolean hudVisible;
    private final Font font;
    private final ItemRenderer itemRenderer;
    private final Minecraft minecraft;
    private final TextureManager textureManager;
    private int x;
    private int y;

    public AdvancementsTrackerWidget(Minecraft minecraft) {
        this.font = minecraft.f_91062_;
        this.itemRenderer = minecraft.m_91291_();
        this.minecraft = minecraft;
        this.textureManager = minecraft.m_91097_();
        positionManager.setInstance(minecraft);
        positionManager.setWidth(120);
        positionManager.setHeight(0);
        positionManager.setBasePosition(PositionManager.BasePosition.MIDDLE_RIGHT);
    }

    @SubscribeEvent
    public static void handleLevelEventLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            return;
        }
        AdvancementsTrackerWidget.updatePredefinedText();
        boolean bl = hudVisible = (Boolean)AdvancementsTrackerWidget.CLIENT.widgetEnabled.get() != false && (Boolean)AdvancementsTrackerWidget.CLIENT.widgetVisible.get() != false;
        if (hudVisible) {
            log.info("Widget will be automatically visible on the start.");
        } else if (Boolean.TRUE.equals(AdvancementsTrackerWidget.CLIENT.widgetEnabled.get())) {
            log.info("Widget will not be automatically visible on the start and you need to use the hot-keys to make it visible!");
        } else {
            log.info("Widget is disabled!");
            return;
        }
        log.info("Set widget size to {}x{}", AdvancementsTrackerWidget.CLIENT.widgetWidth.get(), AdvancementsTrackerWidget.CLIENT.widgetHeight.get());
        positionManager.setHeight((Integer)AdvancementsTrackerWidget.CLIENT.widgetHeight.get());
        positionManager.setWidth((Integer)AdvancementsTrackerWidget.CLIENT.widgetWidth.get());
        log.info("Set widget base position to: {}", AdvancementsTrackerWidget.CLIENT.widgetPosition.get());
        positionManager.setBasePosition((PositionManager.BasePosition)((Object)AdvancementsTrackerWidget.CLIENT.widgetPosition.get()));
        log.info("Set widget position top offset {} and left offset {}", AdvancementsTrackerWidget.CLIENT.widgetTop.get(), AdvancementsTrackerWidget.CLIENT.widgetLeft.get());
        positionManager.setPositionX((Integer)AdvancementsTrackerWidget.CLIENT.widgetLeft.get());
        positionManager.setPositionY((Integer)AdvancementsTrackerWidget.CLIENT.widgetTop.get());
    }

    public static void reloadConfig() {
        positionManager.setHeight((Integer)AdvancementsTrackerWidget.CLIENT.widgetHeight.get());
        positionManager.setWidth((Integer)AdvancementsTrackerWidget.CLIENT.widgetWidth.get());
        positionManager.setBasePosition((PositionManager.BasePosition)((Object)AdvancementsTrackerWidget.CLIENT.widgetPosition.get()));
        positionManager.setPositionX((Integer)AdvancementsTrackerWidget.CLIENT.widgetLeft.get());
        positionManager.setPositionY((Integer)AdvancementsTrackerWidget.CLIENT.widgetTop.get());
    }

    public static void updateTrackedAdvancements() {
        trackedAdvancements = TrackedAdvancementsManager.getTrackedAdvancements();
    }

    public static void toggleVisibility() {
        hudVisible = !hudVisible;
    }

    private static void updatePredefinedText() {
        noAdvancementsText = Component.m_237115_((String)"advancements_tracker.advancementsWidget.noAdvancements").m_7220_((Component)Component.m_237110_((String)HOT_KEY_ADVANCEMENT_TRACKER, (Object[])new Object[]{ModKeyMapping.KEY_SHOW_WIDGET.m_90863_()}).m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.WHITE);
        noTrackedAdvancementsText = Component.m_237115_((String)"advancements_tracker.advancementsWidget.noTrackedAdvancements").m_7220_((Component)Component.m_237110_((String)HOT_KEY_ADVANCEMENT_OVERVIEW, (Object[])new Object[]{ModKeyMapping.KEY_SHOW_OVERVIEW.m_90863_()}).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237110_((String)HOT_KEY_ADVANCEMENT_TRACKER, (Object[])new Object[]{ModKeyMapping.KEY_SHOW_WIDGET.m_90863_()}).m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.WHITE);
    }

    @SubscribeEvent
    public void renderOverlay(RenderGuiOverlayEvent.Pre event) {
        if (!hudVisible || this.minecraft.f_91066_.f_92063_) {
            return;
        }
        if (this.minecraft.f_91080_ != null && !(this.minecraft.f_91080_ instanceof ChatScreen)) {
            return;
        }
        if (event.getOverlay() != VanillaGuiOverlay.SCOREBOARD.type()) {
            return;
        }
        positionManager.updateWindow();
        this.x = positionManager.getPositionX();
        this.y = positionManager.getPositionY();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        this.renderTitle(guiGraphics);
        if (TrackedAdvancementsManager.hasTrackedAdvancements()) {
            MultiBufferSource.BufferSource multiBufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            Objects.requireNonNull(this.font);
            this.renderAdvancements(guiGraphics, multiBufferSource, this.x, this.y + 9 + 4);
        } else if (AdvancementsManager.hasAdvancements()) {
            Objects.requireNonNull(this.font);
            this.renderNoTrackedAdvancements(guiGraphics, this.x, this.y + 9 + 4);
        } else {
            Objects.requireNonNull(this.font);
            this.renderNoAdvancements(guiGraphics, this.x, this.y + 9 + 4);
        }
    }

    private void renderTitle(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85836_();
        int n = positionManager.getPositionXWidth();
        Objects.requireNonNull(this.font);
        guiGraphics.m_280509_(this.x, this.y, n, this.y + 9 + 2, 0x70000000);
        guiGraphics.m_280614_(this.font, (Component)ADVANCEMENT_TITLE_TEXT, this.x + 2, this.y + 2, 0xAAAAAA, false);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderNoTrackedAdvancements(GuiGraphics guiGraphics, int x, int y) {
        Objects.requireNonNull(this.font);
        int textContentHeight = (9 + 2) * 11;
        int textContentWidth = positionManager.getWidth();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280509_(x, y, x + textContentWidth, y + textContentHeight, 0x70000000);
        guiGraphics.m_280554_(this.font, (FormattedText)noTrackedAdvancementsText, x + 5, y + 5, textContentWidth - 10, textContentHeight - 5);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderNoAdvancements(GuiGraphics guiGraphics, int x, int y) {
        Objects.requireNonNull(this.font);
        int textContentHeight = (9 + 2) * 9;
        int textContentWidth = positionManager.getWidth();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280509_(x, y, x + textContentWidth, y + textContentHeight, 0x70000000);
        guiGraphics.m_280554_(this.font, (FormattedText)noAdvancementsText, x + 5, y + 5, textContentWidth - 10, textContentHeight - 5);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderAdvancements(GuiGraphics guiGraphics, MultiBufferSource.BufferSource multiBufferSource, int x, int y) {
        guiGraphics.m_280168_().m_85836_();
        int topPos = y;
        int numberOfAdvancementsRendered = 0;
        try {
            for (AdvancementEntry advancementEntry : trackedAdvancements) {
                Objects.requireNonNull(this.font);
                if (topPos + 9 * 4 < positionManager.getWindowHeightScaled()) {
                    topPos += this.renderAdvancement(guiGraphics, multiBufferSource, x, topPos, advancementEntry) + 2;
                    ++numberOfAdvancementsRendered;
                    continue;
                }
                this.renderAdvancementEllipsis(guiGraphics, x, topPos, trackedAdvancements.size(), numberOfAdvancementsRendered);
                break;
            }
        }
        catch (ConcurrentModificationException exception) {
            log.debug("Advancement list was modified during rendering. This is expected in some cases.");
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderAdvancementEllipsis(GuiGraphics guiGraphics, int x, int y, int numberOfAdvancements, int numberOfAdvancementsRendered) {
        guiGraphics.m_280168_().m_85836_();
        int n = positionManager.getPositionXWidth();
        Objects.requireNonNull(this.font);
        guiGraphics.m_280509_(x, y, n, y + 9, 0x70000000);
        guiGraphics.m_280168_().m_85849_();
        float textScale = 0.75f;
        MutableComponent text = Component.m_237110_((String)"advancements_tracker.advancementsWidget.notAllVisible", (Object[])new Object[]{numberOfAdvancementsRendered, numberOfAdvancements});
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(textScale, textScale, textScale);
        guiGraphics.m_280430_(this.font, (Component)text, Math.round((float)(x + 16) / textScale), Math.round((float)(y + 2) / textScale), 0xAAAAAA);
        guiGraphics.m_280168_().m_85849_();
    }

    private int renderAdvancement(GuiGraphics guiGraphics, MultiBufferSource.BufferSource multiBufferSource, int x, int y, AdvancementEntry advancementEntry) {
        int maxFontWidth = positionManager.getWidth() - 2;
        int referenceTopPosition = y + 3;
        int referenceLeftPosition = x + 2;
        float titleScale = 0.75f;
        int titlePaddingLeft = 10;
        int titlePaddingRight = advancementEntry.getProgress().getProgressTotal() > 1 ? 20 : 0;
        int titleWidth = (float)advancementEntry.getTitleWidth() * titleScale > (float)(maxFontWidth - titlePaddingLeft - titlePaddingRight) ? maxFontWidth - titlePaddingLeft - titlePaddingRight - Math.round(7.0f * titleScale) : maxFontWidth - titlePaddingLeft - titlePaddingRight;
        int titleWidthScaled = Math.round((float)titleWidth / titleScale);
        FormattedCharSequence titleText = Language.m_128107_().m_5536_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{this.font.m_92854_((FormattedText)advancementEntry.getTitle(), titleWidthScaled)}));
        float descriptionScale = 0.75f;
        List descriptionParts = this.font.m_92923_((FormattedText)advancementEntry.getDescription(), Math.round((float)maxFontWidth / descriptionScale) - 3);
        int descriptionLines = 1;
        Objects.requireNonNull(this.font);
        Objects.requireNonNull(this.font);
        int expectedContentSize = Math.round(9.0f * titleScale + 3.0f + (9.0f * descriptionScale + 3.0f) * (float)Math.min(descriptionParts.size(), 3));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280509_(x, y, positionManager.getPositionXWidth(), y + expectedContentSize, 0x70000000);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(titleScale, titleScale, titleScale);
        guiGraphics.m_280648_(this.font, titleText, Math.round((float)(referenceLeftPosition + titlePaddingLeft) / titleScale), Math.round((float)referenceTopPosition / titleScale), 0xFFFF55);
        if (titleWidth != maxFontWidth - titlePaddingLeft - titlePaddingRight) {
            guiGraphics.m_280614_(this.font, Constants.ELLIPSIS, Math.round((float)(referenceLeftPosition + titlePaddingLeft) / titleScale + (float)titleWidthScaled), Math.round((float)referenceTopPosition / titleScale), 0xFFFF55, false);
        }
        guiGraphics.m_280168_().m_85849_();
        if (advancementEntry.getProgress().getProgressTotal() > 1) {
            float progressScale = 0.6f;
            int progressPositionLeft = referenceLeftPosition + maxFontWidth - Math.round((float)advancementEntry.getProgress().getProgressStringWidth() * progressScale) - 2;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(progressScale, progressScale, progressScale);
            guiGraphics.m_280488_(this.font, advancementEntry.getProgress().getProgressString(), Math.round((float)progressPositionLeft / progressScale), Math.round((float)(referenceTopPosition - 1) / progressScale), 0xFFFF55);
            guiGraphics.m_280168_().m_85849_();
        }
        Objects.requireNonNull(this.font);
        referenceTopPosition += (int)(9.0f * titleScale + 3.0f);
        if (advancementEntry.getIcon() != null) {
            guiGraphics.m_280168_().m_85836_();
            this.renderGuiItem(advancementEntry.getIcon(), multiBufferSource, referenceLeftPosition - 4, referenceTopPosition - 14, 0.65f);
            guiGraphics.m_280168_().m_85849_();
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(descriptionScale, descriptionScale, descriptionScale);
        for (FormattedCharSequence descriptionPart : descriptionParts) {
            boolean shouldEnd = false;
            guiGraphics.m_280648_(this.font, descriptionPart, Math.round((float)referenceLeftPosition / descriptionScale), Math.round((float)referenceTopPosition / descriptionScale), advancementEntry.getDescriptionColor());
            if (descriptionParts.size() >= 3 && descriptionLines == 3) {
                guiGraphics.m_280614_(this.font, Constants.ELLIPSIS, Math.round((float)referenceLeftPosition / descriptionScale + ((float)this.font.m_92724_(descriptionPart) / descriptionScale < (float)maxFontWidth / descriptionScale - 3.0f ? (float)this.font.m_92724_(descriptionPart) / descriptionScale - 7.0f : (float)maxFontWidth / descriptionScale - 7.0f)), Math.round((float)referenceTopPosition / descriptionScale), 0xFFFFFF, false);
                shouldEnd = true;
            } else if (descriptionParts.size() == 2 && descriptionLines == 2) {
                shouldEnd = true;
            }
            Objects.requireNonNull(this.font);
            referenceTopPosition += (int)(9.0f * descriptionScale + 3.0f);
            if (shouldEnd) break;
            ++descriptionLines;
        }
        guiGraphics.m_280168_().m_85849_();
        return referenceTopPosition - y;
    }

    @Deprecated
    private void renderGuiItem(ItemStack itemStack, MultiBufferSource.BufferSource multiBufferSource, int x, int y, float scale) {
        this.renderGuiItem(itemStack, multiBufferSource, x, y, scale, this.itemRenderer.m_174264_(itemStack, null, null, 0));
    }

    @Deprecated
    private void renderGuiItem(ItemStack itemStack, MultiBufferSource.BufferSource multiBufferSource, int x, int y, float scale, BakedModel model) {
        boolean flag;
        this.textureManager.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack modelPoseStack = RenderSystem.getModelViewStack();
        modelPoseStack.m_85836_();
        modelPoseStack.m_252880_((float)x, (float)y, 100.0f);
        modelPoseStack.m_85837_(8.0, 8.0, 0.0);
        modelPoseStack.m_85841_(scale, -scale, scale);
        modelPoseStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack modelPoseStack1 = new PoseStack();
        boolean bl = flag = !model.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        this.itemRenderer.m_115143_(itemStack, ItemDisplayContext.GUI, false, modelPoseStack1, (MultiBufferSource)multiBufferSource, 0xF000F0, OverlayTexture.f_118083_, model);
        multiBufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        modelPoseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    static {
        hudVisible = true;
    }
}

