/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntry;
import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntryProgress;
import de.markusbordihn.advancementstracker.client.gui.panel.AdvancementInfoPanel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class AdvancementDetailScreen
extends Screen {
    protected static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private static final ResourceLocation windowBackground = new ResourceLocation("textures/gui/advancements/window.png");
    private AdvancementEntry advancementEntry;
    private AdvancementEntryProgress progress;
    private AdvancementInfoPanel advancementInfoPanel;
    private int maxWidth;
    private int maxHeight;
    private int top;
    private int left;

    public AdvancementDetailScreen(AdvancementEntry advancementEntry) {
        this(advancementEntry.getTitle());
        this.advancementEntry = advancementEntry;
        this.progress = advancementEntry.getProgress();
    }

    protected AdvancementDetailScreen(Component component) {
        super(component);
    }

    private List<String> prepareInfoContent() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(this.advancementEntry.getDescriptionString());
        if (this.progress.getRemainingCriteriaNumber() > 0 || this.progress.getCompletedCriteriaNumber() > 0) {
            info.add(" ");
            info.add(Component.m_237115_((String)"advancements_tracker.advancementsScreen.criteria").getString());
            if (this.progress.getRemainingCriteriaNumber() > 0) {
                for (String remainingCriteria : this.progress.getRemainingCriteriaHumanReadable()) {
                    info.add("\u274c " + remainingCriteria);
                }
            }
            if (this.progress.getCompletedCriteriaNumber() > 0) {
                for (String completedCriteria : this.progress.getCompletedCriteriaHumanReadable()) {
                    info.add("\u2714 " + completedCriteria);
                }
            }
        }
        if (this.advancementEntry.hasExperienceReward() || this.advancementEntry.hasLootReward() || this.advancementEntry.hasRecipesReward()) {
            info.add(" ");
            info.add(Component.m_237115_((String)"advancements_tracker.advancementsScreen.rewards").getString());
            if (this.advancementEntry.hasExperienceReward()) {
                info.add("+ " + Component.m_237110_((String)"advancements_tracker.advancementsScreen.experience", (Object[])new Object[]{this.advancementEntry.getRewardsExperience()}).getString());
            }
            if (this.advancementEntry.hasLootReward()) {
                for (ResourceLocation loot : this.advancementEntry.getRewardsLoot()) {
                    info.add("+ " + loot.toString());
                }
            }
            if (this.advancementEntry.hasRecipesReward()) {
                for (ResourceLocation recipe : this.advancementEntry.getRewardsRecipes()) {
                    info.add("+ " + recipe.toString());
                }
            }
        }
        return info;
    }

    public void m_7856_() {
        this.maxHeight = Math.min(this.f_96544_ - 30, 260);
        this.maxWidth = 252;
        this.left = (this.f_96543_ - this.maxWidth) / 2;
        this.top = (this.f_96544_ - this.maxHeight) / 2;
        this.advancementInfoPanel = new AdvancementInfoPanel(this.f_96541_, this.maxWidth - 18, this.maxHeight - 38, this.top + 18, this.left + 3);
        this.advancementInfoPanel.setInfo(this.prepareInfoContent());
        this.m_142416_((GuiEventListener)this.advancementInfoPanel);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 201.0f);
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.advancementInfoPanel != null) {
            this.advancementInfoPanel.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 201.0f);
        int heightPerPart = this.maxHeight / 2;
        RenderSystem.enableBlend();
        guiGraphics.m_280218_(windowBackground, this.left, this.top, 0, 0, this.maxWidth, heightPerPart);
        guiGraphics.m_280218_(windowBackground, this.left, this.top + heightPerPart, 0, 150 - heightPerPart, this.maxWidth, heightPerPart + 10);
        guiGraphics.m_280024_(this.left + 9, this.top + 18, this.left + this.maxWidth - 9, this.top + this.maxHeight - 20, -1072689136, -804253680);
        RenderSystem.disableBlend();
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, this.left + 22, this.top + 6, this.advancementEntry.getTitleColor());
        if (this.advancementEntry.getIcon() != null && this.f_96541_ != null) {
            guiGraphics.m_280480_(this.advancementEntry.getIcon(), this.left + 4, this.top + 1);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseY >= (double)this.top && mouseY <= (double)(this.top + this.maxHeight) && mouseX >= (double)this.left && mouseX <= (double)(this.left + this.maxWidth);
    }
}

