/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.gui.panel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementInfoPanel
extends ScrollPanel {
    protected static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private static final int PADDING = 6;
    private List<FormattedCharSequence> lines = Collections.emptyList();
    private Font font;

    public AdvancementInfoPanel(Minecraft minecraft, int width, int height, int top, int left) {
        super(minecraft, width, height, top, left + 6);
        this.font = minecraft.f_91062_;
    }

    public void setInfo(List<String> lines) {
        this.lines = this.resizeContent(lines);
    }

    public void clearInfo() {
        this.lines = Collections.emptyList();
    }

    private List<FormattedCharSequence> resizeContent(List<String> lines) {
        ArrayList<FormattedCharSequence> result = new ArrayList<FormattedCharSequence>();
        for (String line : lines) {
            if (line == null) {
                result.add(null);
                continue;
            }
            Component chat = ForgeHooks.newChatWithLinks((String)line, (boolean)false);
            int maxTextLength = this.width - 12;
            if (maxTextLength < 0) continue;
            Style textStyle = Style.f_131099_;
            if (line.startsWith("\u2714")) {
                textStyle = Style.f_131099_.m_178520_(65280);
            } else if (line.startsWith("\u274c")) {
                textStyle = Style.f_131099_.m_178520_(0xFF0000);
            }
            result.addAll(Language.m_128107_().m_128112_(this.font.m_92865_().m_92414_((FormattedText)chat, maxTextLength, textStyle)));
        }
        return result;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    protected int getContentHeight() {
        int height = 5;
        int n = this.lines.size();
        Objects.requireNonNull(this.font);
        if ((height += n * 9) < this.bottom - this.top - 8) {
            height = this.bottom - this.top - 8;
        }
        return height;
    }

    protected int getScrollAmount() {
        Objects.requireNonNull(this.font);
        return 9 * 3;
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 201.0f);
        for (FormattedCharSequence line : this.lines) {
            if (line != null) {
                RenderSystem.enableBlend();
                guiGraphics.m_280648_(this.font, line, this.left + 6, relativeY, 0xFFFFFF);
                RenderSystem.disableBlend();
            }
            Objects.requireNonNull(this.font);
            relativeY += 9;
        }
        guiGraphics.m_280168_().m_85849_();
    }
}

