/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.gui.panel;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.advancementstracker.Constants;
import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntry;
import de.markusbordihn.advancementstracker.client.advancements.TrackedAdvancementsManager;
import de.markusbordihn.advancementstracker.client.gui.screens.AdvancementsTrackerScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementCategoryPanel
extends ObjectSelectionList<RootAdvancementEntry> {
    protected static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private final int listLeft;
    private final int listWidth;
    private AdvancementsTrackerScreen parent;

    public AdvancementCategoryPanel(AdvancementsTrackerScreen parent, int listWidth, int top, int listLeft, int bottom) {
        Minecraft minecraft = parent.getMinecraftInstance();
        int n = parent.f_96544_;
        Objects.requireNonNull(parent.getFontRenderer());
        super(minecraft, listWidth, n, top, bottom, 9 * 3 + 8);
        this.parent = parent;
        this.listWidth = listWidth;
        this.listLeft = listLeft;
        this.m_93507_(listLeft);
        this.m_93488_(false);
        this.m_93471_(false);
    }

    public void refreshList() {
        this.m_93516_();
        this.parent.buildRootAdvancementsList(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0), mod -> new RootAdvancementEntry((AdvancementEntry)mod, this.parent));
        if (this.m_93511_() == null && this.parent.getSelectedRootAdvancement() != null) {
            this.refreshSelection();
            for (int i = 0; i < this.m_5773_(); ++i) {
                if (this.m_93500_(i) == null || ((RootAdvancementEntry)this.m_93500_((int)i)).advancementEntry == null || ((RootAdvancementEntry)this.m_93500_((int)i)).advancementEntry != this.parent.getSelectedRootAdvancement()) continue;
                this.m_6987_((AbstractSelectionList.Entry)((RootAdvancementEntry)this.m_93500_(i)));
            }
        }
        if (this.m_93511_() == null && this.m_5773_() > 0 && this.m_93500_(0) != null) {
            this.refreshSelection();
            RootAdvancementEntry rootAdvancementEntry = (RootAdvancementEntry)this.m_93500_(0);
            this.parent.setSelectedRootAdvancement(rootAdvancementEntry);
        }
    }

    private void refreshSelection() {
        RootAdvancementEntry rootAdvancementEntry = (RootAdvancementEntry)this.m_93511_();
        if (rootAdvancementEntry != null) {
            this.m_6987_((AbstractSelectionList.Entry)rootAdvancementEntry);
            this.m_93498_((AbstractSelectionList.Entry)rootAdvancementEntry);
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return !this.parent.showingAdvancementDetail() && mouseY >= (double)this.f_93390_ && mouseY <= (double)this.f_93391_ && mouseX >= (double)this.f_93393_ && mouseX <= (double)(this.f_93392_ + 5);
    }

    protected int m_5756_() {
        return this.listWidth + this.listLeft;
    }

    public int m_5759_() {
        return this.listWidth;
    }

    public class RootAdvancementEntry
    extends ObjectSelectionList.Entry<RootAdvancementEntry> {
        private static final ResourceLocation miscTexture = new ResourceLocation("advancements_tracker", "textures/gui/misc.png");
        private final AdvancementEntry advancementEntry;
        private final AdvancementsTrackerScreen parent;
        private final Font font;
        private final int descriptionColor;
        private final int iconWidth;
        private final int titleColor;
        private FormattedCharSequence titleParts;
        private List<FormattedCharSequence> descriptionParts;
        private boolean isSelected = false;
        private boolean isMouseOvered = false;
        private int maxFontWidth;
        private int titleWidth;

        RootAdvancementEntry(AdvancementEntry advancementEntry, AdvancementsTrackerScreen parent) {
            this.advancementEntry = advancementEntry;
            this.descriptionColor = advancementEntry.getDescriptionColor();
            this.font = parent.getFontRenderer();
            this.parent = parent;
            this.titleColor = advancementEntry.getTitleColor();
            this.iconWidth = 14;
            this.maxFontWidth = AdvancementCategoryPanel.this.listWidth - this.iconWidth - 4;
            this.titleWidth = advancementEntry.getTitleWidth() > this.maxFontWidth ? this.maxFontWidth - 6 : this.maxFontWidth;
            this.titleParts = Language.m_128107_().m_5536_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{this.font.m_92854_((FormattedText)advancementEntry.getTitle(), this.titleWidth)}));
            this.descriptionParts = this.font.m_92923_((FormattedText)advancementEntry.getDescription(), this.maxFontWidth);
        }

        public AdvancementEntry getAdvancementEntry() {
            return this.advancementEntry;
        }

        private void renderBackground(GuiGraphics guiGraphics, int top, int entryWidth, int entryHeight) {
            if (this.advancementEntry.getBackground() == null) {
                return;
            }
            if (this.isSelected || this.isMouseOvered) {
                RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280163_(this.advancementEntry.getBackground(), AdvancementCategoryPanel.this.getLeft() + 1, top - 1, 0.0f, 0.0f, entryWidth - 2, entryHeight + 2, 16, 16);
            guiGraphics.m_280168_().m_85849_();
        }

        private void renderIcon(GuiGraphics guiGraphics, int top) {
            if (this.advancementEntry.getIcon() == null) {
                return;
            }
            guiGraphics.m_280480_(this.advancementEntry.getIcon(), AdvancementCategoryPanel.this.getLeft() + 1, top + 6);
        }

        private void renderTrackedAdvancementsStatus(GuiGraphics guiGraphics, int top, int left, int entryWidth) {
            if (TrackedAdvancementsManager.hasTrackedAdvancement(this.advancementEntry)) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
                guiGraphics.m_280163_(miscTexture, (left + entryWidth - 12) * 2, (top + 1) * 2, 81.0f, 6.0f, 16, 16, 256, 256);
                guiGraphics.m_280168_().m_85849_();
            }
        }

        private void renderDecoration(GuiGraphics guiGraphics, int top, int entryWidth, int entryHeight) {
            int topPosition = top - 2;
            int leftPosition = AdvancementCategoryPanel.this.getLeft();
            int rightPosition = leftPosition + entryWidth - 2;
            int bottomPosition = top + entryHeight;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280163_(miscTexture, leftPosition, topPosition, 0.0f, 0.0f, entryWidth - 1, 1, entryWidth - 1, 256);
            guiGraphics.m_280163_(miscTexture, rightPosition, topPosition + 1, 255.0f, 0.0f, 1, entryHeight + 2, 256, entryHeight);
            guiGraphics.m_280163_(miscTexture, leftPosition, bottomPosition, 0.0f, 255.0f, entryWidth - 1, 1, entryWidth - 1, 256);
            guiGraphics.m_280163_(miscTexture, leftPosition, topPosition + 1, 0.0f, 0.0f, 1, entryHeight + 2, 256, entryHeight);
            guiGraphics.m_280168_().m_85849_();
        }

        public Component m_142172_() {
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.advancementEntry.getTitleString()});
        }

        public void m_6311_(GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isFocused, float partialTick) {
            this.isSelected = AdvancementCategoryPanel.this.m_7987_(entryIdx);
            this.isMouseOvered = this.m_5953_(mouseX, mouseY);
            int textPositionLeft = left + this.iconWidth;
            this.renderBackground(guiGraphics, top, entryWidth, entryHeight);
            if (this.isSelected) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (this.isMouseOvered) {
                RenderSystem.setShaderColor((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
            this.renderIcon(guiGraphics, top);
            this.renderTrackedAdvancementsStatus(guiGraphics, top, left, entryWidth);
            int currentTitleColor = this.isSelected ? 0xFFFF00 : this.titleColor;
            guiGraphics.m_280648_(this.font, this.titleParts, textPositionLeft + 3, top + 1, currentTitleColor);
            if (this.titleWidth != this.maxFontWidth) {
                guiGraphics.m_280614_(this.font, Constants.ELLIPSIS, textPositionLeft + this.titleWidth, top + 1, currentTitleColor, false);
            }
            int descriptionLines = 1;
            for (FormattedCharSequence descriptionPart : this.descriptionParts) {
                Objects.requireNonNull(this.font);
                int descriptionTopPosition = top + (2 + 9) * descriptionLines;
                guiGraphics.m_280648_(this.font, descriptionPart, textPositionLeft + 3, descriptionTopPosition, this.descriptionColor);
                if (this.descriptionParts.size() >= 3 && descriptionLines == 2) {
                    guiGraphics.m_280614_(this.font, Constants.ELLIPSIS, textPositionLeft + (this.font.m_92724_(descriptionPart) < this.maxFontWidth - 6 ? this.font.m_92724_(descriptionPart) + 6 : this.maxFontWidth - 6), descriptionTopPosition, 0xFFFFFF, false);
                    break;
                }
                ++descriptionLines;
            }
            this.renderDecoration(guiGraphics, top, entryWidth, entryHeight);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.parent.setSelectedRootAdvancement(this);
                AdvancementCategoryPanel.this.m_6987_((AbstractSelectionList.Entry)this);
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }
}

