/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.advancements;

import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntry;
import de.markusbordihn.advancementstracker.client.gui.widget.AdvancementsTrackerWidget;
import de.markusbordihn.advancementstracker.config.ClientConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TrackedAdvancementsManager {
    protected static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private static Set<AdvancementEntry> trackedAdvancements = new HashSet<AdvancementEntry>();
    private static List<String> trackedAdvancementsDefault = new ArrayList<String>();
    private static List<String> trackedAdvancementsLocal = new ArrayList<String>();
    private static List<String> trackedAdvancementsRemote = new ArrayList<String>();
    private static String serverId;

    protected TrackedAdvancementsManager() {
    }

    @SubscribeEvent
    public static void handleLevelEventLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ServerData serverData = minecraft != null ? minecraft.m_91089_() : null;
        serverId = serverData != null ? String.format("%s:%s::", serverData.f_105362_.replaceAll("\\W", "_"), serverData.f_105367_) : null;
        trackedAdvancements = new HashSet<AdvancementEntry>();
        log.info("Preparing tracked advancements ...");
        trackedAdvancementsDefault = (List)ClientConfig.CLIENT.trackedAdvancements.get();
        if (!trackedAdvancementsDefault.isEmpty()) {
            log.info("Loading default (config) tracked advancements: {}", trackedAdvancementsDefault);
        }
        if (!(trackedAdvancementsLocal = (List)ClientConfig.CLIENT.trackedAdvancementsLocal.get()).isEmpty()) {
            log.info("Loading local (user) tracked advancements: {}", trackedAdvancementsLocal);
        }
        if (serverId != null && !(trackedAdvancementsRemote = (List)ClientConfig.CLIENT.trackedAdvancementsRemote.get()).isEmpty()) {
            log.info("Loading remote ({}) tracked advancements: {} ...", (Object)serverId, trackedAdvancementsRemote);
        }
        TrackedAdvancementsManager.updateTrackerWidget();
    }

    public static void checkForTrackedAdvancement(AdvancementEntry advancement) {
        if (advancement.getProgress().isDone()) {
            return;
        }
        AdvancementEntry trackedAdvancement = null;
        if (!trackedAdvancementsDefault.isEmpty()) {
            for (String trackedAdvancementDefault : trackedAdvancementsDefault) {
                if (!advancement.getIdString().equals(trackedAdvancementDefault)) continue;
                log.debug("Adding default tracked advancement {}", (Object)advancement);
                trackedAdvancement = advancement;
                break;
            }
        }
        if (!trackedAdvancementsRemote.isEmpty() && serverId != null) {
            for (String cachedAdvancementEntry : trackedAdvancementsRemote) {
                if (cachedAdvancementEntry.isEmpty() || cachedAdvancementEntry.isEmpty() || !cachedAdvancementEntry.startsWith(serverId) || !advancement.getIdString().equals(cachedAdvancementEntry.split("::", 2)[1])) continue;
                log.debug("Adding remote tracked advancement {}", (Object)advancement);
                trackedAdvancement = advancement;
                break;
            }
        }
        if (!trackedAdvancementsLocal.isEmpty() && serverId == null) {
            for (String cachedAdvancementEntry : trackedAdvancementsLocal) {
                if (!advancement.getIdString().equals(cachedAdvancementEntry)) continue;
                log.debug("Adding local tracked advancement {}", (Object)advancement);
                trackedAdvancement = advancement;
                break;
            }
        }
        if (trackedAdvancement != null) {
            TrackedAdvancementsManager.trackAdvancement(trackedAdvancement, false);
        }
    }

    public static void toggleTrackedAdvancement(AdvancementEntry advancement) {
        if (advancement.getProgress().isDone()) {
            return;
        }
        if (TrackedAdvancementsManager.isTrackedAdvancement(advancement)) {
            TrackedAdvancementsManager.untrackAdvancement(advancement);
        } else {
            TrackedAdvancementsManager.trackAdvancement(advancement);
        }
    }

    public static void trackAdvancement(AdvancementEntry advancement) {
        TrackedAdvancementsManager.trackAdvancement(advancement, true);
    }

    public static void trackAdvancement(AdvancementEntry advancement, boolean autosave) {
        if (advancement.getProgress().isDone()) {
            log.warn("Advancement {} is already done, no need to track it.", (Object)advancement);
            return;
        }
        for (AdvancementEntry trackedAdvancementEntry : trackedAdvancements) {
            if (trackedAdvancementEntry.getId() != advancement.getId()) continue;
            log.warn("Advancement {} is already tracked.", (Object)advancement);
            return;
        }
        log.info("Track Advancement {}", (Object)advancement);
        trackedAdvancements.add(advancement);
        if (autosave) {
            TrackedAdvancementsManager.saveTrackedAdvancements();
        }
        TrackedAdvancementsManager.updateTrackerWidget();
    }

    private static void saveTrackedAdvancements() {
        TrackedAdvancementsManager.saveTrackedAdvancementsRemote();
        TrackedAdvancementsManager.saveTrackedAdvancementsLocal();
    }

    private static void saveTrackedAdvancementsRemote() {
        if (serverId == null) {
            return;
        }
        ArrayList<Object> trackedAdvancementsToSave = new ArrayList<Object>();
        for (String trackedAdvancementRemote : trackedAdvancementsRemote) {
            if (trackedAdvancementRemote.isEmpty() || trackedAdvancementRemote.isEmpty() || trackedAdvancementRemote.startsWith(serverId)) continue;
            trackedAdvancementsToSave.add(trackedAdvancementRemote);
        }
        for (AdvancementEntry trackedAdvancementEntry : trackedAdvancements) {
            trackedAdvancementsToSave.add(serverId + trackedAdvancementEntry.getIdString());
        }
        ClientConfig.CLIENT.trackedAdvancementsRemote.set(trackedAdvancementsToSave.stream().distinct().collect(Collectors.toList()));
        trackedAdvancementsRemote = (List)ClientConfig.CLIENT.trackedAdvancementsRemote.get();
        ClientConfig.CLIENT.trackedAdvancements.save();
    }

    private static void saveTrackedAdvancementsLocal() {
        if (serverId != null) {
            return;
        }
        ArrayList<String> trackedAdvancementsToSave = new ArrayList<String>();
        for (AdvancementEntry trackedAdvancementEntry : trackedAdvancements) {
            trackedAdvancementsToSave.add(trackedAdvancementEntry.getIdString());
        }
        ClientConfig.CLIENT.trackedAdvancementsLocal.set(trackedAdvancementsToSave.stream().distinct().collect(Collectors.toList()));
        trackedAdvancementsLocal = (List)ClientConfig.CLIENT.trackedAdvancementsLocal.get();
        ClientConfig.CLIENT.trackedAdvancements.save();
    }

    public static void untrackAdvancement(Advancement advancement) {
        TrackedAdvancementsManager.untrackAdvancement(advancement.m_138327_());
    }

    public static void untrackAdvancement(AdvancementEntry advancement) {
        TrackedAdvancementsManager.untrackAdvancement(advancement.getId());
    }

    public static void untrackAdvancement(ResourceLocation advancementId) {
        AdvancementEntry existingAdvancementEntry = null;
        for (AdvancementEntry trackedAdvancementEntry : trackedAdvancements) {
            if (trackedAdvancementEntry.getId() != advancementId) continue;
            existingAdvancementEntry = trackedAdvancementEntry;
            break;
        }
        if (existingAdvancementEntry != null) {
            trackedAdvancements.remove(existingAdvancementEntry);
            TrackedAdvancementsManager.saveTrackedAdvancements();
            TrackedAdvancementsManager.updateTrackerWidget();
        }
    }

    public static int numOfTrackedAdvancements() {
        return trackedAdvancements.size();
    }

    public static boolean hasTrackedAdvancement(AdvancementEntry advancementEntry) {
        ResourceLocation rootAdvancementId = advancementEntry.getId();
        for (AdvancementEntry trackedAdvancementEntry : trackedAdvancements) {
            if (trackedAdvancementEntry.rootAdvancement == null || trackedAdvancementEntry.rootAdvancement.m_138327_() != rootAdvancementId) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTrackedAdvancements() {
        return !trackedAdvancements.isEmpty();
    }

    public static boolean isTrackedAdvancement(AdvancementEntry advancementEntry) {
        return TrackedAdvancementsManager.isTrackedAdvancement(advancementEntry.getAdvancement());
    }

    public static boolean isTrackedAdvancement(Advancement advancement) {
        for (AdvancementEntry trackedAdvancementEntry : trackedAdvancements) {
            if (trackedAdvancementEntry.getId() != advancement.m_138327_()) continue;
            return true;
        }
        return false;
    }

    public static Set<AdvancementEntry> getTrackedAdvancements() {
        return trackedAdvancements;
    }

    private static void updateTrackerWidget() {
        AdvancementsTrackerWidget.updateTrackedAdvancements();
    }
}

