/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.advancements;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntryProgress;
import de.markusbordihn.advancementstracker.client.advancements.TrackedAdvancementsManager;
import java.util.Comparator;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementEntry
implements Comparator<AdvancementEntry> {
    protected static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private final ResourceLocation id;
    private final String idString;
    private final Component descriptionComponent;
    private final Component titleComponent;
    private final Font font;
    private final Minecraft minecraft = Minecraft.m_91087_();
    Advancement advancement;
    Advancement rootAdvancement;
    DisplayInfo displayInfo;
    ResourceLocation rootId;
    String[][] requirements;
    int rootLevel = 0;
    private ItemStack icon;
    private ResourceLocation background;
    private String description;
    private String title;
    private FrameType frameType;
    private int titleWidth;
    private int descriptionColor = -2236963;
    private int titleColor = -1;
    private AdvancementRewards rewards = null;
    private ResourceLocation[] rewardsLoot = null;
    private ResourceLocation[] rewardsRecipes = null;
    private Integer rewardsExperience = null;
    private boolean hasExperienceReward = false;
    private boolean hasLootReward = false;
    private boolean hasRecipesReward = false;
    private boolean hasRewards = false;
    private boolean hasRewardsData = false;
    private boolean hasRewardsLoaded = false;
    private AdvancementEntryProgress advancementProgress;

    AdvancementEntry(Advancement advancement, AdvancementProgress advancementProgress) {
        DisplayInfo rootAdvancementDisplayInfo;
        this.font = this.minecraft.f_91062_;
        this.advancementProgress = new AdvancementEntryProgress(advancement, advancementProgress);
        this.advancement = advancement;
        this.displayInfo = advancement.m_138320_();
        this.id = advancement.m_138327_();
        this.idString = advancement.m_138327_().toString();
        this.rootAdvancement = advancement.m_138319_();
        this.requirements = advancement.m_138329_();
        if (this.rootAdvancement != null) {
            while (this.rootAdvancement.m_138319_() != null) {
                this.rootAdvancement = this.rootAdvancement.m_138319_();
                ++this.rootLevel;
            }
            this.rootId = this.rootAdvancement.m_138327_();
        }
        if (this.displayInfo != null) {
            this.background = this.displayInfo.m_14991_();
            this.icon = this.displayInfo.m_14990_();
            this.title = this.displayInfo.m_14977_().getString();
            this.titleWidth = this.font.m_92895_(this.title);
            TextColor titleTextColor = this.displayInfo.m_14977_().m_7383_().m_131135_();
            if (titleTextColor != null) {
                this.titleColor = titleTextColor.m_131265_();
            }
            this.description = this.displayInfo.m_14985_().getString();
            TextColor descriptionTextColor = this.displayInfo.m_14985_().m_7383_().m_131135_();
            if (descriptionTextColor != null) {
                this.descriptionColor = descriptionTextColor.m_131265_();
            }
            this.frameType = this.displayInfo.m_14992_();
        } else {
            this.background = null;
            this.title = advancement.m_138327_().toString();
            this.titleWidth = this.font.m_92895_(this.title);
        }
        if (this.background == null && this.rootAdvancement != null && (rootAdvancementDisplayInfo = this.rootAdvancement.m_138320_()) != null) {
            this.background = rootAdvancementDisplayInfo.m_14991_();
        }
        this.descriptionComponent = Component.m_237113_((String)AdvancementEntry.stripControlCodes(this.description));
        this.titleComponent = Component.m_237113_((String)AdvancementEntry.stripControlCodes(this.title));
        this.rewards = advancement.m_138321_();
    }

    private static String stripControlCodes(String value) {
        return value == null ? "" : StringUtil.m_14406_((String)value);
    }

    public static Comparator<AdvancementEntry> sortByTitle() {
        return Comparator.comparing(firstAdvancementEntry -> firstAdvancementEntry.title);
    }

    public static Comparator<AdvancementEntry> sortByStatus() {
        return (firstAdvancementEntry, secondAdvancementEntry) -> {
            int result = Boolean.compare(firstAdvancementEntry.getProgress().isDone(), secondAdvancementEntry.getProgress().isDone());
            if (result == 0) {
                result = firstAdvancementEntry.title.compareTo(secondAdvancementEntry.title);
            }
            return result;
        };
    }

    public boolean isTracked() {
        return TrackedAdvancementsManager.isTrackedAdvancement(this.advancement);
    }

    public AdvancementEntryProgress getProgress() {
        return this.advancementProgress;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getIdString() {
        return this.idString;
    }

    public ResourceLocation getBackground() {
        return this.background;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public Advancement getAdvancement() {
        return this.advancement;
    }

    public Component getDescription() {
        return this.descriptionComponent;
    }

    public String getDescriptionString() {
        return this.description;
    }

    public int getDescriptionColor() {
        return this.descriptionColor;
    }

    public String getSortName() {
        return StringUtils.toLowerCase((String)AdvancementEntry.stripControlCodes(this.title));
    }

    public Component getTitle() {
        return this.titleComponent;
    }

    public String getTitleString() {
        return this.title;
    }

    public int getTitleWidth() {
        return this.titleWidth;
    }

    public int getTitleColor() {
        return this.titleColor;
    }

    public void updateAdvancementProgress(AdvancementProgress advancementProgress) {
        this.advancementProgress.update(advancementProgress);
    }

    public Integer getRewardsExperience() {
        JsonObject rewardsData;
        if (this.rewardsExperience == null && (rewardsData = this.getRewardsData()) != null) {
            this.rewardsExperience = GsonHelper.m_13824_((JsonObject)rewardsData, (String)"experience", (int)0);
            if (this.rewardsExperience > 0) {
                this.hasExperienceReward = true;
                this.hasRewardsData = true;
            }
        }
        return this.rewardsExperience;
    }

    public ResourceLocation[] getRewardsLoot() {
        JsonArray lootArray;
        JsonObject rewardsData;
        if (this.rewardsLoot == null && (rewardsData = this.getRewardsData()) != null && (lootArray = GsonHelper.m_13832_((JsonObject)rewardsData, (String)"loot", (JsonArray)new JsonArray())) != null) {
            this.rewardsLoot = new ResourceLocation[lootArray.size()];
            for (int j = 0; j < this.rewardsLoot.length; ++j) {
                this.rewardsLoot[j] = new ResourceLocation(GsonHelper.m_13805_((JsonElement)lootArray.get(j), (String)("loot[" + j + "]")));
                this.hasLootReward = true;
                this.hasRewardsData = true;
            }
        }
        return this.rewardsLoot;
    }

    public ResourceLocation[] getRewardsRecipes() {
        JsonArray recipesArray;
        JsonObject rewardsData;
        if (this.rewardsRecipes == null && (rewardsData = this.getRewardsData()) != null && (recipesArray = GsonHelper.m_13832_((JsonObject)rewardsData, (String)"recipes", (JsonArray)new JsonArray())) != null) {
            this.rewardsRecipes = new ResourceLocation[recipesArray.size()];
            for (int k = 0; k < this.rewardsRecipes.length; ++k) {
                this.rewardsRecipes[k] = new ResourceLocation(GsonHelper.m_13805_((JsonElement)recipesArray.get(k), (String)("recipes[" + k + "]")));
                this.hasRecipesReward = true;
                this.hasRewardsData = true;
            }
        }
        return this.rewardsRecipes;
    }

    private JsonObject getRewardsData() {
        JsonElement rewardsJson = null;
        try {
            JsonObject rewardsObject;
            rewardsJson = this.rewards.m_9997_();
            if (rewardsJson != null && (rewardsObject = rewardsJson.getAsJsonObject()) != null) {
                return rewardsObject;
            }
        }
        catch (JsonParseException | IllegalStateException throwable) {
            // empty catch block
        }
        return null;
    }

    public boolean hasRewards() {
        if (!this.hasRewardsLoaded && this.rewards != null) {
            this.hasRewards = this.getRewardsExperience() != null || this.getRewardsLoot() != null || this.getRewardsRecipes() != null;
            this.hasRewardsLoaded = true;
        }
        return this.hasRewards;
    }

    public boolean hasRewardsData() {
        return this.hasRewards() && this.hasRewardsData;
    }

    public boolean hasExperienceReward() {
        return this.hasExperienceReward;
    }

    public boolean hasLootReward() {
        return this.hasLootReward;
    }

    public boolean hasRecipesReward() {
        return this.hasRecipesReward;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AdvancementEntry)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.id == ((AdvancementEntry)object).id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compare(AdvancementEntry firstAdvancementEntry, AdvancementEntry secondAdvancementEntry) {
        return firstAdvancementEntry.id.compareTo(secondAdvancementEntry.id);
    }

    public String toString() {
        if (this.rootAdvancement == null) {
            return String.format("[Root Advancement] (%s) %s: %s %s", this.frameType, this.id, this.title, Float.valueOf(this.advancementProgress.getProgress()));
        }
        return String.format("[Advancement %s] (%s) %s => %s: %s %s", this.rootLevel, this.frameType, this.rootId, this.id, this.title, Float.valueOf(this.advancementProgress.getProgress()));
    }
}

