/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item;

import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.yirmiri.dungeonsdelight.core.init.DDDamageTypes;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class RawCreeperFoodItem
extends ConsumableItem {
    public RawCreeperFoodItem(Item.Properties properties, boolean hasFoodEffectTooltip) {
        super(properties, hasFoodEffectTooltip);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.raw_creeper_food", (Object[])new Object[0]).m_130940_(ChatFormatting.RED));
            super.m_7373_(stack, level, tooltip, isAdvanced);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity living) {
        this.explodeRawCreeper(living);
        return super.m_5922_(stack, level, living);
    }

    private void explodeRawCreeper(LivingEntity living) {
        if (!living.m_9236_().f_46443_) {
            living.m_9236_().m_254849_((Entity)living, living.m_20185_(), living.m_20186_(), living.m_20189_(), 3.0f, Level.ExplosionInteraction.BLOCK);
            living.m_6469_(ModDamageTypes.getSimpleDamageSource((Level)living.m_9236_(), DDDamageTypes.RAW_CREEPER), 8.0f);
            this.spawnLingeringCloud(living);
        }
    }

    private void spawnLingeringCloud(LivingEntity living) {
        Collection effects = living.m_21220_();
        if (!effects.isEmpty()) {
            AreaEffectCloud cloud = new AreaEffectCloud(living.m_9236_(), living.m_20185_(), living.m_20186_(), living.m_20189_());
            cloud.m_19712_(2.5f);
            cloud.m_19732_(-0.5f);
            cloud.m_19740_(10);
            cloud.m_19734_(cloud.m_19748_() / 2);
            cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
            for (MobEffectInstance effectInstance : effects) {
                cloud.m_19716_(new MobEffectInstance(effectInstance));
            }
            living.m_9236_().m_7967_((Entity)cloud);
            living.m_21219_();
        }
    }
}

