/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WormrootsStalkBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    protected static final VoxelShape BASE_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0);
    protected static final VoxelShape UP_SHAPE = Block.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static Map<Direction, BooleanProperty> DIRECTION_TO_PROPERTY = new HashMap<Direction, BooleanProperty>();
    public static Map<Direction, VoxelShape> DIRECTION_TO_SHAPE = new HashMap<Direction, VoxelShape>();

    public WormrootsStalkBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
        DIRECTION_TO_PROPERTY.put(Direction.NORTH, NORTH);
        DIRECTION_TO_PROPERTY.put(Direction.EAST, EAST);
        DIRECTION_TO_PROPERTY.put(Direction.SOUTH, SOUTH);
        DIRECTION_TO_PROPERTY.put(Direction.WEST, WEST);
        DIRECTION_TO_PROPERTY.put(Direction.UP, UP);
        DIRECTION_TO_PROPERTY.put(Direction.DOWN, DOWN);
        DIRECTION_TO_SHAPE.put(Direction.NORTH, NORTH_SHAPE);
        DIRECTION_TO_SHAPE.put(Direction.EAST, EAST_SHAPE);
        DIRECTION_TO_SHAPE.put(Direction.SOUTH, SOUTH_SHAPE);
        DIRECTION_TO_SHAPE.put(Direction.WEST, WEST_SHAPE);
        DIRECTION_TO_SHAPE.put(Direction.UP, UP_SHAPE);
        DIRECTION_TO_SHAPE.put(Direction.DOWN, DOWN_SHAPE);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape axisShape = BASE_SHAPE;
        ArrayList<VoxelShape> additionalShapes = new ArrayList<VoxelShape>(List.of());
        for (Direction direction : f_60441_) {
            if (state.m_61143_((Property)f_55923_) == Direction.Axis.Y) {
                xor = (Boolean)state.m_61143_((Property)UP) ^ (Boolean)state.m_61143_((Property)DOWN);
                if (!((Boolean)state.m_61143_((Property)UP)).booleanValue() && !((Boolean)state.m_61143_((Property)DOWN)).booleanValue() || xor && !((Boolean)state.m_61143_((Property)NORTH)).booleanValue() && !((Boolean)state.m_61143_((Property)EAST)).booleanValue() && !((Boolean)state.m_61143_((Property)SOUTH)).booleanValue() && !((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                    additionalShapes.add(UP_SHAPE);
                    additionalShapes.add(DOWN_SHAPE);
                }
            } else if (state.m_61143_((Property)f_55923_) == Direction.Axis.X) {
                xor = (Boolean)state.m_61143_((Property)EAST) ^ (Boolean)state.m_61143_((Property)WEST);
                if (!((Boolean)state.m_61143_((Property)EAST)).booleanValue() && !((Boolean)state.m_61143_((Property)WEST)).booleanValue() || xor && !((Boolean)state.m_61143_((Property)NORTH)).booleanValue() && !((Boolean)state.m_61143_((Property)UP)).booleanValue() && !((Boolean)state.m_61143_((Property)SOUTH)).booleanValue() && !((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                    additionalShapes.add(EAST_SHAPE);
                    additionalShapes.add(WEST_SHAPE);
                }
            } else if (state.m_61143_((Property)f_55923_) == Direction.Axis.Z) {
                xor = (Boolean)state.m_61143_((Property)NORTH) ^ (Boolean)state.m_61143_((Property)SOUTH);
                if (!((Boolean)state.m_61143_((Property)NORTH)).booleanValue() && !((Boolean)state.m_61143_((Property)SOUTH)).booleanValue() || xor && !((Boolean)state.m_61143_((Property)EAST)).booleanValue() && !((Boolean)state.m_61143_((Property)UP)).booleanValue() && !((Boolean)state.m_61143_((Property)WEST)).booleanValue() && !((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                    additionalShapes.add(NORTH_SHAPE);
                    additionalShapes.add(SOUTH_SHAPE);
                }
            }
            if (!((Boolean)state.m_61143_((Property)DIRECTION_TO_PROPERTY.get(direction))).booleanValue()) continue;
            additionalShapes.add(DIRECTION_TO_SHAPE.get(direction));
        }
        for (int i = 0; i < additionalShapes.size(); ++i) {
            axisShape = Shapes.m_83110_((VoxelShape)axisShape, (VoxelShape)((VoxelShape)additionalShapes.get(i)));
        }
        return axisShape;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        HashMap<Direction, Boolean> directionMap = new HashMap<Direction, Boolean>();
        for (Direction direction : f_60441_) {
            BlockState blockState = ctx.m_43725_().m_8055_(ctx.m_8083_().m_121945_(direction));
            if (blockState.m_60713_((Block)this) && !((Boolean)blockState.m_61143_((Property)DIRECTION_TO_PROPERTY.get(direction.m_122424_()))).booleanValue()) {
                directionMap.put(direction, true);
                continue;
            }
            directionMap.put(direction, false);
        }
        ctx.m_43725_().m_186460_(ctx.m_8083_(), (Block)this, 1);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_))).m_61124_((Property)NORTH, (Comparable)((Boolean)directionMap.get(Direction.NORTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)directionMap.get(Direction.EAST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)directionMap.get(Direction.SOUTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)directionMap.get(Direction.WEST)))).m_61124_((Property)UP, (Comparable)((Boolean)directionMap.get(Direction.UP)))).m_61124_((Property)DOWN, (Comparable)((Boolean)directionMap.get(Direction.DOWN)));
    }

    public BlockState m_7417_(BlockState state, Direction unusedDir, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return this.updateState(world, pos, state);
    }

    private BlockState updateState(LevelAccessor world, BlockPos pos, BlockState state) {
        HashMap<Direction, Boolean> directionMap = new HashMap<Direction, Boolean>();
        for (Direction direction : f_60441_) {
            BlockState blockState = world.m_8055_(pos.m_121945_(direction));
            directionMap.put(direction, blockState.m_60713_((Block)this));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)directionMap.get(Direction.NORTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)directionMap.get(Direction.EAST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)directionMap.get(Direction.SOUTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)directionMap.get(Direction.WEST)))).m_61124_((Property)UP, (Comparable)((Boolean)directionMap.get(Direction.UP)))).m_61124_((Property)DOWN, (Comparable)((Boolean)directionMap.get(Direction.DOWN)));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.updateState((LevelAccessor)level, pos, state);
        super.m_213897_(state, level, pos, random);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, f_55923_, NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        for (Direction direction : Direction.values()) {
            BlockPos targetPos = blockPos.m_121945_(direction);
            BlockState state = level.m_8055_(targetPos);
            if (!state.m_60795_() && !state.m_247087_()) continue;
            return true;
        }
        return false;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState blockState) {
        ArrayList<Direction> allDirections = new ArrayList<Direction>(List.of(Direction.values()));
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        for (Direction direction : allDirections) {
            BlockPos targetPos = pos.m_121945_(direction);
            BlockState state = level.m_8055_(targetPos);
            if (!state.m_60795_() && !state.m_247087_()) continue;
            validDirections.add(direction);
        }
        if (!validDirections.isEmpty()) {
            this.growWormrootStalks(level, pos, (Direction)validDirections.get(0));
            ArrayList otherDirections = new ArrayList(validDirections);
            otherDirections.remove(validDirections.get(0));
            Collections.shuffle(otherDirections, new Random(random.m_188505_()));
            List skippedDirections = otherDirections.subList(0, Math.min(3, otherDirections.size()));
            for (Direction dir : otherDirections) {
                if (skippedDirections.contains(dir) && random.m_188501_() < 0.6f) continue;
                this.growWormrootStalks(level, pos, dir);
            }
        }
    }

    private void growWormrootStalks(ServerLevel level, BlockPos pos, Direction direction) {
        if (level.m_8055_(pos.m_121945_(direction)).m_247087_()) {
            BlockState newState = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)direction.m_122434_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos.m_121945_(direction)).m_76152_() == Fluids.f_76193_))).m_61124_((Property)DIRECTION_TO_PROPERTY.get(direction.m_122424_()), (Comparable)Boolean.valueOf(true));
            newState = this.updateState((LevelAccessor)level, pos.m_121945_(direction), newState);
            level.m_7731_(pos.m_121945_(direction), newState, 3);
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11756_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

