/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.purpoid.ai;

import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;

public abstract class AbstractPurpoidTeleportGoal
extends Goal {
    protected final Purpoid purpoid;
    private int notMovingTicks;

    protected AbstractPurpoidTeleportGoal(Purpoid purpoid) {
        this.purpoid = purpoid;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Purpoid purpoid = this.purpoid;
        this.notMovingTicks = !purpoid.m_21566_().m_24995_() ? this.notMovingTicks + 1 : 0;
        boolean canUse = false;
        if ((purpoid.forcedRelativeTeleportingPos != null || this.notMovingTicks >= 20 && !purpoid.isBoosting() && !purpoid.hasTeleportCooldown()) && !purpoid.m_20159_() && purpoid.isNoEndimationPlaying()) {
            AABB collisionBox;
            BlockPos teleportPos = this.generateTeleportPos(purpoid, purpoid.m_217043_());
            Level level = purpoid.m_9236_();
            if (teleportPos != null && level.m_46805_(teleportPos) && level.m_45772_(collisionBox = purpoid.m_6972_(purpoid.m_20089_()).m_20384_((double)((float)teleportPos.m_123341_() + 0.5f), (double)teleportPos.m_123342_(), (double)((float)teleportPos.m_123343_() + 0.5f))) && level.m_5450_((Entity)purpoid, Shapes.m_83064_((AABB)collisionBox)) && !level.m_46855_(collisionBox)) {
                this.beginTeleportation(purpoid, teleportPos);
                canUse = true;
            }
        }
        purpoid.forcedRelativeTeleportingPos = null;
        return canUse;
    }

    public boolean m_8045_() {
        return this.purpoid.getTeleportController().isTeleporting();
    }

    public boolean m_183429_() {
        return true;
    }

    protected void beginTeleportation(Purpoid purpoid, BlockPos pos) {
        purpoid.resetTeleportCooldown();
        purpoid.getTeleportController().beginTeleportation(purpoid, pos, false);
    }

    @Nullable
    protected abstract BlockPos generateTeleportPos(Purpoid var1, RandomSource var2);
}

