/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.puffbug.ai;

import com.teamabnormals.endergetic.api.entity.util.RayTraceHelper;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PuffBugAttackGoal
extends Goal {
    public static final float SHOOT_RANGE = 8.0f;
    private final PuffBug puffbug;
    @Nullable
    private Path path;
    private int delayCounter;
    private int ticksChased;

    public PuffBugAttackGoal(PuffBug puffbug) {
        this.puffbug = puffbug;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        LivingEntity target = this.puffbug.m_5448_();
        if (target == null) {
            return false;
        }
        if (!PuffBug.CAN_ANGER.test(target)) {
            return false;
        }
        if (!this.puffbug.isInflated()) {
            return false;
        }
        Path newPath = this.puffbug.m_21573_().m_6570_((Entity)target, 0);
        if (newPath != null) {
            this.path = newPath;
        }
        return !this.puffbug.m_20159_() && this.puffbug.getLaunchDirection() == null && this.path != null;
    }

    public void m_8056_() {
        this.puffbug.m_21573_().m_26536_(this.path, 2.5);
        this.puffbug.m_21561_(true);
        this.delayCounter = 0;
        this.ticksChased = 0;
    }

    public boolean m_8045_() {
        if (!this.puffbug.isInflated()) {
            return false;
        }
        return this.puffbug.getLaunchDirection() == null && this.puffbug.m_5448_() != null && PuffBug.CAN_ANGER.test(this.puffbug.m_5448_());
    }

    public void m_8037_() {
        --this.delayCounter;
        ++this.ticksChased;
        LivingEntity target = this.puffbug.m_5448_();
        this.puffbug.m_21563_().m_24960_((Entity)target, 20.0f, 20.0f);
        if (this.delayCounter <= 0) {
            Path path = this.puffbug.m_21573_().m_7864_(target.m_20183_().m_6630_(4), 4);
            if (path != null && this.puffbug.m_21573_().m_26536_(path, 3.5)) {
                this.delayCounter += 5;
            }
            if (this.puffbug.m_20270_((Entity)target) <= 8.0f) {
                Vec3 distance = new Vec3(target.m_20185_() - this.puffbug.m_20185_(), target.m_20186_() - this.puffbug.m_20186_(), target.m_20189_() - this.puffbug.m_20189_());
                float pitch = -((float)(Mth.m_14136_((double)distance.m_7098_(), (double)Mth.m_14116_((float)((float)(distance.m_7096_() * distance.m_7096_() + distance.m_7094_() * distance.m_7094_())))) * 57.2957763671875));
                float yaw = (float)(Mth.m_14136_((double)distance.m_7094_(), (double)distance.m_7096_()) * 57.2957763671875) - 90.0f;
                double startingDistance = 8.0;
                startingDistance *= startingDistance;
                HitResult blockTrace = this.traceBlocks(Mth.m_14177_((float)pitch), yaw);
                if (blockTrace != null) {
                    startingDistance = blockTrace.m_82450_().m_82557_(this.puffbug.m_20299_(1.0f));
                }
                EntityHitResult rayTrace = RayTraceHelper.rayTraceEntityResult((Entity)this.puffbug, Mth.m_14177_((float)pitch), yaw, 8.0, startingDistance, 1.0f);
                if (this.ticksChased >= 30 && this.canFitNewCollisionShape() && rayTrace != null && rayTrace.m_6662_() != HitResult.Type.BLOCK && pitch > 30.0f) {
                    this.puffbug.setLaunchDirection(Mth.m_14177_((float)pitch), yaw);
                    this.puffbug.m_21573_().m_26573_();
                }
            }
        }
    }

    public void m_8041_() {
        LivingEntity target = this.puffbug.m_5448_();
        if (!EntitySelector.f_20406_.test(target)) {
            this.puffbug.m_6710_(null);
        }
        this.puffbug.m_21561_(false);
        this.puffbug.m_21573_().m_26573_();
    }

    private boolean canFitNewCollisionShape() {
        return this.puffbug.m_6162_() ? this.puffbug.m_9236_().m_45772_(this.getBoundingBoxForSize(PuffBug.PROJECTILE_SIZE_CHILD).m_82386_(0.0, (double)0.225f, 0.0)) : this.puffbug.m_9236_().m_45772_(this.getBoundingBoxForSize(PuffBug.PROJECTILE_SIZE).m_82386_(0.0, (double)0.225f, 0.0));
    }

    private AABB getBoundingBoxForSize(EntityDimensions size) {
        float f = size.f_20377_ / 2.0f;
        Vec3 vec3d = new Vec3(this.puffbug.m_20185_() - (double)f, this.puffbug.m_20186_(), this.puffbug.m_20189_() - (double)f);
        Vec3 vec3d1 = new Vec3(this.puffbug.m_20185_() + (double)f, this.puffbug.m_20186_() + (double)size.f_20378_, this.puffbug.m_20189_() + (double)f);
        return new AABB(vec3d, vec3d1);
    }

    public HitResult traceBlocks(float pitch, float yaw) {
        Vec3 eyeVec = this.puffbug.m_20299_(1.0f);
        Vec3 lookVec = RayTraceHelper.getVectorForRotation(pitch, yaw);
        Vec3 vec3d2 = eyeVec.m_82520_(lookVec.m_7096_() * 8.0, lookVec.m_7098_() * 8.0, lookVec.m_7094_() * 8.0);
        return this.puffbug.m_9236_().m_45547_(new ClipContext(eyeVec, vec3d2, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.puffbug));
    }

    public boolean m_183429_() {
        return true;
    }
}

