/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.booflo.ai;

import com.teamabnormals.endergetic.common.entity.bolloom.BolloomFruit;
import com.teamabnormals.endergetic.common.entity.booflo.BoofloAdolescent;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class AdolescentAttackGoal
extends Goal {
    protected final BoofloAdolescent attacker;
    protected int attackTick;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private long lastCanUseCheck;
    private boolean canPenalize = false;

    public AdolescentAttackGoal(BoofloAdolescent attacker, double speedIn, boolean useLongMemory) {
        this.attacker = attacker;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.attacker.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        if (!this.attacker.isHungry()) {
            return false;
        }
        this.lastCanUseCheck = i;
        Entity target = this.attacker.getBoofloAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (this.attacker.hasFruit()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.path = this.attacker.m_21573_().m_6570_(target, 0);
                this.delayCounter = 4 + this.attacker.m_217043_().m_188503_(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.attacker.m_21573_().m_6570_(target, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(target) >= this.attacker.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
    }

    public boolean m_8045_() {
        Entity target = this.attacker.getBoofloAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (this.attacker.hasFruit()) {
            return false;
        }
        if (!this.attacker.isHungry()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.m_21573_().m_26571_();
        }
        if (!this.attacker.m_21444_(target.m_20183_())) {
            return false;
        }
        return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_();
    }

    public void m_8056_() {
        this.attacker.m_21573_().m_26536_(this.path, this.speedTowardsTarget);
        this.attacker.m_21561_(true);
        this.delayCounter = 0;
    }

    public void m_8041_() {
        Entity target = this.attacker.getBoofloAttackTarget();
        if (!EntitySelector.f_20406_.test(target)) {
            this.attacker.setBoofloAttackTarget(null);
        }
        this.attacker.m_21561_(false);
        this.attacker.m_21573_().m_26573_();
    }

    public void m_8037_() {
        Entity target = this.attacker.getBoofloAttackTarget();
        this.attacker.m_21563_().m_24960_(target, 10.0f, 10.0f);
        double distToEnemySqr = this.attacker.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
        --this.delayCounter;
        if ((this.longMemory || this.attacker.m_21574_().m_148306_(target)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || target.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.m_217043_().m_188501_() < 0.05f)) {
            this.targetX = target.m_20185_();
            this.targetY = target.m_20191_().f_82289_;
            this.targetZ = target.m_20189_();
            this.delayCounter = 4 + this.attacker.m_217043_().m_188503_(7);
            if (distToEnemySqr > 1024.0) {
                this.delayCounter += 10;
            } else if (distToEnemySqr > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.attacker.m_21573_().m_5624_(target, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.tryToCapturePrey(target, distToEnemySqr);
    }

    protected void tryToCapturePrey(Entity prey, double distToEnemySqr) {
        double attackReach = this.getAttackReachSqr(prey);
        if (distToEnemySqr <= attackReach && this.attackTick <= 0) {
            this.attackTick = 20;
            this.attacker.setHasFruit(true);
            if (prey instanceof BolloomFruit) {
                ((BolloomFruit)prey).onBroken(false);
                prey.m_146870_();
            }
        }
    }

    protected double getAttackReachSqr(Entity attackTarget) {
        return this.attacker.m_20205_() * 2.0f * this.attacker.m_20205_() * 2.0f + attackTarget.m_20205_();
    }

    @Nullable
    public Path getPathToEntity(Entity entity) {
        BlockPos pos = entity.m_20183_();
        for (int y = 0; y < 8; ++y) {
            pos = pos.m_6625_(y);
            if (entity.m_20193_().f_46443_ || !entity.m_20193_().m_8055_(pos).m_60815_() && entity.m_20193_().m_8055_(pos).m_60819_().m_76178_()) continue;
            return this.attacker.m_21573_().m_7864_(pos, 0);
        }
        return this.attacker.m_21573_().m_7864_(entity.m_20183_(), 0);
    }

    public boolean m_183429_() {
        return true;
    }
}

