/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.block.entity;

import com.google.common.collect.Lists;
import com.teamabnormals.endergetic.api.entity.util.DetectionHelper;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import com.teamabnormals.endergetic.core.registry.EEBlockEntityTypes;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class PuffBugHiveTileEntity
extends BlockEntity {
    private final List<HiveOccupantData> hiveOccupants = Lists.newArrayList();
    private int ticksTillResetTeleport;
    private int teleportCooldown;
    private boolean shouldReset;

    public PuffBugHiveTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EEBlockEntityTypes.PUFFBUG_HIVE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PuffBugHiveTileEntity hive) {
        if (!level.f_46443_ && !hive.hiveOccupants.isEmpty()) {
            if (hive.ticksTillResetTeleport > 0) {
                --hive.ticksTillResetTeleport;
            } else if (hive.shouldReset) {
                hive.hiveOccupants.forEach(occupent -> {
                    occupent.teleportSide = null;
                });
                hive.shouldReset = false;
            }
            if (hive.teleportCooldown > 0) {
                --hive.teleportCooldown;
            }
            for (int i = 0; i < hive.hiveOccupants.size(); ++i) {
                HiveOccupantData hiveOccupant = hive.hiveOccupants.get(i);
                if (hiveOccupant.occupant == null) {
                    hive.hiveOccupants.remove(i);
                    continue;
                }
                hiveOccupant.tick(level);
            }
        }
    }

    public void addBugToHive(PuffBug puffBug) {
        if (!this.isHiveFull()) {
            this.hiveOccupants.add(new HiveOccupantData(puffBug.m_20148_()));
        }
    }

    public void alertPuffBugs(@Nullable LivingEntity breaker) {
        this.hiveOccupants.forEach(Occupant -> {
            PuffBug puffBug = Occupant.getOccupant(this.f_58857_);
            BlockPos hivePos = this.f_58858_;
            if (puffBug != null) {
                if (puffBug.m_5448_() == null) {
                    puffBug.setAttachedHiveSide(Direction.UP);
                    puffBug.tryToTeleportToHive(hivePos);
                }
                if (breaker == null) {
                    Object target = DetectionHelper.getClosestEntity(this.f_58857_.m_6443_(LivingEntity.class, new AABB(hivePos).m_82400_(12.0), PuffBug.CAN_ANGER), hivePos.m_123341_(), hivePos.m_123342_(), hivePos.m_123343_());
                    if (target != null && puffBug.m_5448_() == null) {
                        puffBug.m_6710_((LivingEntity)target);
                    }
                } else {
                    puffBug.m_6710_(breaker);
                    puffBug.setHivePos(null);
                }
            }
        });
        this.addTeleportCooldown();
    }

    public List<HiveOccupantData> getHiveOccupants() {
        return this.hiveOccupants;
    }

    public int getTotalBugsInHive() {
        return this.hiveOccupants.size();
    }

    public boolean isHiveFull() {
        return this.getTotalBugsInHive() >= 5;
    }

    public boolean canTeleportTo() {
        return this.teleportCooldown <= 0;
    }

    public void addTeleportCooldown() {
        this.teleportCooldown = 500;
    }

    @Nullable
    private HiveOccupantData getOccupentByUUID(UUID uuid) {
        for (HiveOccupantData occupents : this.hiveOccupants) {
            if (occupents.occupant != uuid) continue;
            return occupents;
        }
        return null;
    }

    public void setBeingTeleportedToBy(PuffBug puffbug, Direction side) {
        HiveOccupantData occupentData = this.getOccupentByUUID(puffbug.m_20148_());
        if (occupentData != null) {
            occupentData.teleportSide = side;
            this.ticksTillResetTeleport = 250;
            this.shouldReset = true;
        }
    }

    public boolean isSideBeingTeleportedTo(Direction side) {
        for (HiveOccupantData occupents : this.hiveOccupants) {
            if (occupents.teleportSide != side) continue;
            return true;
        }
        return false;
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("HiveOccupants", (Tag)HiveOccupantData.createCompoundList(this));
        compound.m_128405_("TeleportCooldown", this.teleportCooldown);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.hiveOccupants.clear();
        ListTag Occupants = compound.m_128437_("HiveOccupants", 10);
        for (int i = 0; i < Occupants.size(); ++i) {
            CompoundTag Occupant = Occupants.m_128728_(i);
            String OccupantUUID = Occupant.m_128425_("OccupantUUID", 8) ? Occupant.m_128461_("OccupantUUID") : "";
            UUID foundUUID = !OccupantUUID.isEmpty() ? UUID.fromString(OccupantUUID) : null;
            this.hiveOccupants.add(new HiveOccupantData(foundUUID));
        }
        this.teleportCooldown = compound.m_128451_("TeleportCooldown");
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean m_6326_() {
        return true;
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public static class HiveOccupantData {
        @Nullable
        private UUID occupant;
        @Nullable
        private Direction teleportSide;

        public HiveOccupantData(@Nullable UUID occupant) {
            this.occupant = occupant;
        }

        public void tick(Level world) {
            if (this.getOccupant(world) == null) {
                this.occupant = null;
            }
        }

        @Nullable
        public PuffBug getOccupant(Level world) {
            Entity entity;
            if (!world.f_46443_ && (entity = ((ServerLevel)world).m_8791_(this.occupant)) instanceof PuffBug) {
                return (PuffBug)entity;
            }
            return null;
        }

        public static ListTag createCompoundList(PuffBugHiveTileEntity hive) {
            ListTag listnbt = new ListTag();
            for (HiveOccupantData occuptentData : hive.hiveOccupants) {
                CompoundTag compound = new CompoundTag();
                if (occuptentData.occupant == null) {
                    compound.m_128359_("OccupantUUID", "");
                } else {
                    compound.m_128359_("OccupantUUID", occuptentData.occupant.toString());
                }
                listnbt.add((Object)compound);
            }
            return listnbt;
        }

        public static boolean isHiveSideEmpty(PuffBugHiveTileEntity hive, Direction direction) {
            for (int i = 0; i < hive.getTotalBugsInHive(); ++i) {
                PuffBug bug = hive.getHiveOccupants().get(i).getOccupant(hive.f_58857_);
                if (bug == null || bug.getAttachedHiveSide() != direction) continue;
                return false;
            }
            return true;
        }
    }
}

