/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FastBlockParticle
extends TextureSheetParticle {
    private final BlockState sourceState;
    private BlockPos sourcePos;
    private final float uCoord;
    private final float vCoord;

    public FastBlockParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, BlockState state) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.f_107215_ = motionX + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.f_107216_ = Math.random() * (double)0.1f;
        this.f_107217_ = motionZ + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.sourceState = state;
        this.m_108337_(Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(state));
        this.f_107226_ = 1.0f;
        this.f_107229_ = 0.6f;
        this.f_107228_ = 0.6f;
        this.f_107227_ = 0.6f;
        this.f_107663_ /= 2.0f;
        this.uCoord = this.f_107223_.m_188501_() * 3.0f;
        this.vCoord = this.f_107223_.m_188501_() * 3.0f;
    }

    protected void multiplyColor(@Nullable BlockPos pos) {
        int i = Minecraft.m_91087_().m_91298_().m_92577_(this.sourceState, (BlockAndTintGetter)this.f_107208_, pos, 0);
        this.f_107227_ *= (float)(i >> 16 & 0xFF) / 255.0f;
        this.f_107228_ *= (float)(i >> 8 & 0xFF) / 255.0f;
        this.f_107229_ *= (float)(i & 0xFF) / 255.0f;
    }

    public FastBlockParticle init() {
        this.sourcePos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        if (!this.sourceState.m_60713_(Blocks.f_50440_)) {
            this.multiplyColor(this.sourcePos);
        }
        return this;
    }

    private Particle updateSprite(BlockPos pos) {
        if (pos != null) {
            this.m_108337_(Minecraft.m_91087_().m_91289_().m_110907_().getTexture(this.sourceState, (Level)this.f_107208_, pos));
        }
        return this;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.f_107216_ -= 0.04 * (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ *= (double)0.98f;
            this.f_107216_ *= (double)0.98f;
            this.f_107217_ *= (double)0.98f;
            if (this.f_107218_) {
                this.f_107215_ *= (double)0.95f;
                this.f_107217_ *= (double)0.95f;
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107429_;
    }

    protected float m_5970_() {
        return this.f_108321_.m_118367_((double)((this.uCoord + 1.0f) / 4.0f * 16.0f));
    }

    protected float m_5952_() {
        return this.f_108321_.m_118367_((double)(this.uCoord / 4.0f * 16.0f));
    }

    protected float m_5951_() {
        return this.f_108321_.m_118393_((double)(this.vCoord / 4.0f * 16.0f));
    }

    protected float m_5950_() {
        return this.f_108321_.m_118393_((double)((this.vCoord + 1.0f) / 4.0f * 16.0f));
    }

    public int m_6355_(float partialTick) {
        int brightnessForRender = super.m_6355_(partialTick);
        int light = 0;
        if (this.f_107208_.m_46805_(this.sourcePos)) {
            light = LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)this.sourcePos);
        }
        return brightnessForRender == 0 ? light : brightnessForRender;
    }

    public static class Factory
    implements ParticleProvider<BlockParticleOption> {
        public Particle createParticle(BlockParticleOption data, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BlockState blockstate = data.m_123642_();
            return !blockstate.m_60795_() && !blockstate.m_60713_(Blocks.f_50110_) ? new FastBlockParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, blockstate).init().updateSprite(data.getPos()) : null;
        }
    }
}

