/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.model.eetle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.blueprint.core.endimator.Endimator;
import com.teamabnormals.blueprint.core.endimator.EndimatorModelPart;
import com.teamabnormals.blueprint.core.endimator.entity.EndimatorEntityModel;
import com.teamabnormals.blueprint.core.endimator.model.EndimatorLayerDefinition;
import com.teamabnormals.blueprint.core.endimator.model.EndimatorPartDefinition;
import com.teamabnormals.endergetic.common.entity.eetle.BroodEetle;
import com.teamabnormals.endergetic.common.entity.eetle.flying.FlyingRotations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class BroodEetleModel
extends EndimatorEntityModel<BroodEetle> {
    private static final float WING_SHOW_THRESHOLD = (float)Math.toRadians(15.0);
    public EndimatorModelPart body;
    public EndimatorModelPart leftShell;
    public EndimatorModelPart rightShell;
    public EndimatorModelPart wingLeft;
    public EndimatorModelPart wingRight;
    public EndimatorModelPart head;
    public EndimatorModelPart egg;
    public EndimatorModelPart leftFrontLeg;
    public EndimatorModelPart rightFrontLeg;
    public EndimatorModelPart leftBackLeg;
    public EndimatorModelPart rightBackLeg;
    public EndimatorModelPart horn;
    public EndimatorModelPart rightMandible;
    public EndimatorModelPart leftMandible;
    public EndimatorModelPart hornTop;
    public EndimatorModelPart eggLayer;
    public EndimatorModelPart eggSack;
    public EndimatorModelPart eggMouthTop;
    public EndimatorModelPart eggMouthBottom;
    public EndimatorModelPart eggMouthLeft;
    public EndimatorModelPart eggMouthRight;
    public EndimatorModelPart leftFrontFoot;
    public EndimatorModelPart rightFrontFoot;
    public EndimatorModelPart leftBackFoot;
    public EndimatorModelPart rightBackFoot;

    public BroodEetleModel(ModelPart root) {
        this.body = (EndimatorModelPart)root.m_171324_("body");
        this.leftShell = (EndimatorModelPart)this.body.m_171324_("leftShell");
        this.rightShell = (EndimatorModelPart)this.body.m_171324_("rightShell");
        this.wingLeft = (EndimatorModelPart)this.body.m_171324_("wingLeft");
        this.wingRight = (EndimatorModelPart)this.body.m_171324_("wingRight");
        this.head = (EndimatorModelPart)this.body.m_171324_("head");
        this.egg = (EndimatorModelPart)this.body.m_171324_("egg");
        this.leftFrontLeg = (EndimatorModelPart)this.body.m_171324_("leftFrontLeg");
        this.rightFrontLeg = (EndimatorModelPart)this.body.m_171324_("rightFrontLeg");
        this.leftBackLeg = (EndimatorModelPart)this.body.m_171324_("leftBackLeg");
        this.rightBackLeg = (EndimatorModelPart)this.body.m_171324_("rightBackLeg");
        this.horn = (EndimatorModelPart)this.head.m_171324_("horn");
        this.rightMandible = (EndimatorModelPart)this.head.m_171324_("rightMandible");
        this.leftMandible = (EndimatorModelPart)this.head.m_171324_("leftMandible");
        this.hornTop = (EndimatorModelPart)this.horn.m_171324_("hornTop");
        this.eggLayer = (EndimatorModelPart)this.egg.m_171324_("eggLayer");
        this.eggSack = (EndimatorModelPart)this.egg.m_171324_("eggSack");
        this.eggMouthTop = (EndimatorModelPart)this.eggSack.m_171324_("eggMouthTop");
        this.eggMouthBottom = (EndimatorModelPart)this.eggSack.m_171324_("eggMouthBottom");
        this.eggMouthLeft = (EndimatorModelPart)this.eggSack.m_171324_("eggMouthLeft");
        this.eggMouthRight = (EndimatorModelPart)this.eggSack.m_171324_("eggMouthRight");
        this.leftFrontFoot = (EndimatorModelPart)this.leftFrontLeg.m_171324_("leftFrontFoot");
        this.rightFrontFoot = (EndimatorModelPart)this.rightFrontLeg.m_171324_("rightFrontFoot");
        this.leftBackFoot = (EndimatorModelPart)this.leftBackLeg.m_171324_("leftBackFoot");
        this.rightBackFoot = (EndimatorModelPart)this.rightBackLeg.m_171324_("rightBackFoot");
        this.endimator = Endimator.compile((ModelPart)root);
        this.eggSack.setShouldScaleChildren(false);
    }

    public static LayerDefinition createLayerDefinition() {
        EndimatorPartDefinition root = EndimatorPartDefinition.root();
        EndimatorPartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171506_(-12.0f, 0.0f, 0.0f, 24.0f, 14.0f, 27.0f, false), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)-15.0f, (float)-0.08726646f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition leftShell = body.addOrReplaceChild("leftShell", CubeListBuilder.m_171558_().m_171514_(217, 0).m_171506_(0.0f, 0.0f, 0.0f, 13.0f, 12.0f, 27.0f, false), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)-0.5f, (float)0.0f, (float)((float)Math.PI / 90), (float)0.0f));
        EndimatorPartDefinition rightShell = body.addOrReplaceChild("rightShell", CubeListBuilder.m_171558_().m_171514_(217, 0).m_171506_(-13.0f, 0.0f, 0.0f, 13.0f, 12.0f, 27.0f, true), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)-0.5f, (float)0.0f, (float)((float)(-Math.PI) / 90), (float)0.0f));
        EndimatorPartDefinition wingLeft = body.addOrReplaceChild("wingLeft", CubeListBuilder.m_171558_().m_171514_(120, 0).m_171506_(0.0f, 0.0f, 0.0f, 12.0f, 0.0f, 40.0f, false), PartPose.m_171423_((float)0.0f, (float)-0.2f, (float)0.0f, (float)0.0f, (float)((float)Math.PI / 180), (float)0.0f));
        EndimatorPartDefinition wingRight = body.addOrReplaceChild("wingRight", CubeListBuilder.m_171558_().m_171514_(120, 0).m_171506_(-12.0f, 0.0f, 0.0f, 12.0f, 0.0f, 40.0f, true), PartPose.m_171423_((float)0.0f, (float)-0.2f, (float)0.0f, (float)0.0f, (float)((float)(-Math.PI) / 180), (float)0.0f));
        EndimatorPartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-8.0f, -6.0f, -14.0f, 16.0f, 12.0f, 14.0f, false), PartPose.m_171423_((float)0.0f, (float)8.5f, (float)1.5f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition egg = body.addOrReplaceChild("egg", CubeListBuilder.m_171558_().m_171514_(61, 0).m_171506_(-13.0f, -10.0f, 0.0f, 26.0f, 20.0f, 17.0f, false), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)24.0f, (float)0.40142572f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition leftFrontLeg = body.addOrReplaceChild("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(103, 79).m_171506_(-5.0f, 0.0f, -2.5f, 5.0f, 14.0f, 5.0f, false), PartPose.m_171423_((float)13.0f, (float)6.0f, (float)5.0f, (float)0.0f, (float)0.08726646f, (float)-0.61086524f));
        EndimatorPartDefinition rightFrontLeg = body.addOrReplaceChild("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(103, 79).m_171506_(0.0f, 0.0f, -2.5f, 5.0f, 14.0f, 5.0f, true), PartPose.m_171423_((float)-13.0f, (float)6.0f, (float)5.0f, (float)0.0f, (float)-0.08726646f, (float)0.61086524f));
        EndimatorPartDefinition leftBackLeg = body.addOrReplaceChild("leftBackLeg", CubeListBuilder.m_171558_().m_171514_(103, 79).m_171506_(-5.0f, 0.0f, -2.5f, 5.0f, 14.0f, 5.0f, false), PartPose.m_171423_((float)13.0f, (float)6.0f, (float)23.0f, (float)0.2617994f, (float)0.08726646f, (float)-0.7853982f));
        EndimatorPartDefinition rightBackLeg = body.addOrReplaceChild("rightBackLeg", CubeListBuilder.m_171558_().m_171514_(103, 79).m_171506_(0.0f, 0.0f, -2.5f, 5.0f, 14.0f, 5.0f, true), PartPose.m_171423_((float)-13.0f, (float)6.0f, (float)23.0f, (float)0.2617994f, (float)-0.08726646f, (float)0.7853982f));
        EndimatorPartDefinition horn = head.addOrReplaceChild("horn", CubeListBuilder.m_171558_().m_171514_(0, 62).m_171506_(-3.0f, -15.0f, -3.0f, 6.0f, 15.0f, 6.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-11.5f, (float)0.34906584f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition rightMandible = head.addOrReplaceChild("rightMandible", CubeListBuilder.m_171558_().m_171514_(93, 60).m_171506_(-15.0f, 0.0f, -16.0f, 15.0f, 0.0f, 15.0f, true), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-13.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition leftMandible = head.addOrReplaceChild("leftMandible", CubeListBuilder.m_171558_().m_171514_(93, 60).m_171506_(0.0f, 0.0f, -15.0f, 15.0f, 0.0f, 15.0f, false), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-14.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition hornTop = horn.addOrReplaceChild("hornTop", CubeListBuilder.m_171558_().m_171514_(62, 38).m_171506_(0.0f, 0.0f, 0.0f, 26.0f, 20.0f, 0.0f, false), PartPose.m_171423_((float)-13.0f, (float)-30.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition eggLayer = egg.addOrReplaceChild("eggLayer", CubeListBuilder.m_171558_().m_171514_(210, 56).m_171506_(-13.0f, 0.0f, 0.0f, 27.0f, 21.0f, 18.0f, false), PartPose.m_171423_((float)-0.5f, (float)-10.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition eggSack = egg.addOrReplaceChild("eggSack", CubeListBuilder.m_171558_().m_171514_(5, 27).m_171506_(-21.0f, -8.0f, 0.0f, 16.0f, 16.0f, 11.0f, false), PartPose.m_171423_((float)13.0f, (float)0.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition eggMouthTop = eggSack.addOrReplaceChild("eggMouthTop", CubeListBuilder.m_171558_().m_171514_(125, 60).m_171506_(0.0f, 13.0f, 0.0f, 21.0f, 21.0f, 17.0f, false), PartPose.m_171423_((float)11.0f, (float)-10.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)1.5707964f));
        EndimatorPartDefinition eggMouthBottom = eggSack.addOrReplaceChild("eggMouthBottom", CubeListBuilder.m_171558_().m_171514_(125, 60).m_171506_(0.0f, -13.0f, 0.0f, 21.0f, 21.0f, 17.0f, false), PartPose.m_171423_((float)-11.0f, (float)10.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)4.712389f));
        EndimatorPartDefinition eggMouthLeft = eggSack.addOrReplaceChild("eggMouthLeft", CubeListBuilder.m_171558_().m_171514_(125, 60).m_171506_(0.0f, 0.0f, 0.0f, 21.0f, 21.0f, 17.0f, false), PartPose.m_171423_((float)-2.0f, (float)10.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        EndimatorPartDefinition eggMouthRight = eggSack.addOrReplaceChild("eggMouthRight", CubeListBuilder.m_171558_().m_171514_(125, 60).m_171506_(0.0f, 0.0f, 0.0f, 21.0f, 21.0f, 17.0f, false), PartPose.m_171423_((float)-24.0f, (float)-10.5f, (float)0.5f, (float)0.0f, (float)0.0061086523f, (float)0.0f));
        EndimatorPartDefinition leftFrontFoot = leftFrontLeg.addOrReplaceChild("leftFrontFoot", CubeListBuilder.m_171558_().m_171514_(77, 61).m_171506_(-3.5f, 0.0f, -3.5f, 7.0f, 14.0f, 7.0f, false), PartPose.m_171423_((float)-2.5f, (float)12.0f, (float)0.0f, (float)((float)Math.PI / 90), (float)0.0f, (float)0.57595867f));
        EndimatorPartDefinition rightFrontFoot = rightFrontLeg.addOrReplaceChild("rightFrontFoot", CubeListBuilder.m_171558_().m_171514_(77, 61).m_171506_(-3.5f, 0.0f, -3.5f, 7.0f, 14.0f, 7.0f, true), PartPose.m_171423_((float)2.5f, (float)12.0f, (float)0.0f, (float)((float)Math.PI / 90), (float)0.0f, (float)-0.57595867f));
        EndimatorPartDefinition leftBackFoot = leftBackLeg.addOrReplaceChild("leftBackFoot", CubeListBuilder.m_171558_().m_171514_(77, 61).m_171506_(-3.5f, 0.0f, -3.5f, 7.0f, 14.0f, 7.0f, false), PartPose.m_171423_((float)-2.5f, (float)12.0f, (float)0.0f, (float)-0.13962634f, (float)0.0f, (float)0.7853982f));
        EndimatorPartDefinition rightBackFoot = rightBackLeg.addOrReplaceChild("rightBackFoot", CubeListBuilder.m_171558_().m_171514_(77, 61).m_171506_(-3.5f, 0.0f, -3.5f, 7.0f, 14.0f, 7.0f, true), PartPose.m_171423_((float)2.5f, (float)12.0f, (float)0.0f, (float)-0.13962634f, (float)0.0f, (float)-0.7853982f));
        return new EndimatorLayerDefinition(root, 300, 100);
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.wingLeft.f_104207_ = this.wingLeft.f_104204_ >= WING_SHOW_THRESHOLD;
        this.wingRight.f_104207_ = this.wingRight.f_104204_ <= -WING_SHOW_THRESHOLD;
        this.body.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(BroodEetle eetle, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_((Entity)eetle, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        FlyingRotations flyingRotations = eetle.getFlyingRotations();
        this.body.f_104203_ += Mth.m_14036_((float)flyingRotations.getRenderFlyPitch(), (float)-30.0f, (float)20.0f) * ((float)Math.PI / 180);
        if (eetle.isFlying()) {
            this.body.f_104205_ = flyingRotations.getRenderFlyRoll() * ((float)Math.PI / 180);
        }
        float flyingProgress = eetle.getFlyingProgress();
        float sleepingProgress = eetle.getSleepingProgress();
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ += 0.35f * flyingProgress + headPitch * ((float)Math.PI / 180) + 0.35f * sleepingProgress + sleepingProgress * 0.06f * Mth.m_14031_((float)(0.08f * ageInTicks));
        this.body.f_104201_ += sleepingProgress * 6.0f;
        float frontLegSleepingX = 0.7f * sleepingProgress;
        float legFlying = 0.52f * flyingProgress;
        this.leftFrontLeg.f_104203_ += legFlying - frontLegSleepingX;
        this.rightFrontLeg.f_104203_ += legFlying - frontLegSleepingX;
        float backLegSleepingX = 0.09f * sleepingProgress;
        this.leftBackLeg.f_104203_ += legFlying + backLegSleepingX;
        this.rightBackLeg.f_104203_ += legFlying + backLegSleepingX;
        float frontLegSleepingZ = 0.52f * sleepingProgress;
        this.leftFrontLeg.f_104205_ -= frontLegSleepingZ;
        this.rightFrontLeg.f_104205_ += frontLegSleepingZ;
        float backLegSleepingZ = 0.33f * sleepingProgress;
        this.leftBackLeg.f_104205_ -= backLegSleepingZ;
        this.rightBackLeg.f_104205_ += backLegSleepingZ;
        float backLegSleepingY = 0.54f * sleepingProgress;
        this.leftBackLeg.f_104204_ += backLegSleepingY;
        this.rightBackLeg.f_104204_ -= backLegSleepingY;
        float healPulseProgress = eetle.getHealPulseProgress();
        float scale = 1.0f + 0.05f * Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks))) + 0.1f * Mth.m_14031_((float)(1.5707964f * healPulseProgress));
        this.eggSack.setScale(scale, scale, scale);
        EndimatorModelPart egg = this.egg;
        float eggScale = 0.15f * healPulseProgress * healPulseProgress * healPulseProgress;
        egg.setScale(egg.f_233553_ + eggScale, egg.f_233554_ + eggScale, egg.f_233555_ + eggScale);
        float eggMouthAngle = 0.087f * Math.abs(Mth.m_14089_((float)(0.05f * ageInTicks))) + 0.79f * eetle.getEggMouthProgress();
        this.eggMouthTop.f_104204_ -= eggMouthAngle;
        this.eggMouthBottom.f_104204_ -= eggMouthAngle;
        this.eggMouthRight.f_104204_ -= eggMouthAngle;
        this.eggMouthLeft.f_104204_ -= eggMouthAngle;
        egg.f_104203_ += BroodEetleModel.computeSmoothCurve(eetle.getEggCannonProgress(), 0.0f, 0.01f, 0.91f) - BroodEetleModel.computeSmoothCurve(eetle.getEggCannonFlyingProgress(), 0.0f, 0.0f, 0.8f) + 0.07f * Mth.m_14031_((float)(0.09f * ageInTicks)) - 0.44f * sleepingProgress;
        float takeOffProgress = eetle.getTakeoffProgress();
        float thirtyDegreeProgress = 0.52f * takeOffProgress;
        this.leftShell.f_104205_ -= thirtyDegreeProgress;
        this.rightShell.f_104205_ += thirtyDegreeProgress;
        this.wingLeft.f_104204_ += thirtyDegreeProgress;
        this.wingRight.f_104204_ -= thirtyDegreeProgress;
        float shellY = 0.87f * takeOffProgress;
        this.leftShell.f_104204_ += shellY;
        this.rightShell.f_104204_ -= shellY;
        if (eetle.isFlying()) {
            float wingX = 0.1f * Mth.m_14031_((float)(8.0f * eetle.getWingFlap())) + 0.26f * takeOffProgress;
            this.wingLeft.f_104203_ += wingX;
            this.wingRight.f_104203_ += wingX;
            float frontLegMoving = Math.abs(Mth.m_14089_((float)(limbSwing * 0.3f))) * 0.21f * limbSwingAmount;
            this.leftFrontLeg.f_104203_ -= frontLegMoving;
            this.rightFrontLeg.f_104203_ -= frontLegMoving;
            float backLegMoving = Math.abs(Mth.m_14031_((float)(limbSwing * 0.3f))) * 0.21f * limbSwingAmount;
            this.leftBackLeg.f_104203_ += backLegMoving;
            this.rightBackLeg.f_104203_ += backLegMoving;
        }
    }

    private static float computeSmoothCurve(float progress, float fromGradient, float toGradient, float max) {
        return (fromGradient - toGradient - 2.0f * max) * (progress * progress * progress) + (3.0f * max - 2.0f * fromGradient - toGradient) * (progress * progress) + fromGradient * progress;
    }
}

