/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.itemstack;

import com.google.common.collect.Maps;
import com.hrznstudio.titanium.itemstack.ItemStackHarness;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemStackHarnessRegistry {
    private static final ItemStackHarnessRegistry INSTANCE = new ItemStackHarnessRegistry();
    private final Map<Supplier<Item>, Function<ItemStack, ItemStackHarness>> harnessCreators = Maps.newHashMap();

    public static void register(Supplier<Item> item, Function<ItemStack, ItemStackHarness> harnessCreator) {
        ItemStackHarnessRegistry.getHarnessCreators().put(item, harnessCreator);
    }

    public static Map<Supplier<Item>, Function<ItemStack, ItemStackHarness>> getHarnessCreators() {
        return ItemStackHarnessRegistry.getInstance().harnessCreators;
    }

    public static Optional<ItemStackHarness> createItemStackHarness(ItemStack itemStack) {
        for (Map.Entry<Supplier<Item>, Function<ItemStack, ItemStackHarness>> itemSupplier : ItemStackHarnessRegistry.getHarnessCreators().entrySet()) {
            if (!itemSupplier.getKey().get().equals(itemStack.m_41720_())) continue;
            return Optional.of(itemSupplier.getValue().apply(itemStack));
        }
        return Optional.empty();
    }

    public static ItemStackHarnessRegistry getInstance() {
        return INSTANCE;
    }
}

