/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.datagen;

import com.github.alexthe666.iceandfire.datagen.AtlasGenerator;
import com.github.alexthe666.iceandfire.datagen.IafBiomeTagGenerator;
import com.github.alexthe666.iceandfire.datagen.IafRecipes;
import com.github.alexthe666.iceandfire.datagen.RegistryDataGenerator;
import com.github.alexthe666.iceandfire.datagen.tags.BannerPatternTagGenerator;
import com.github.alexthe666.iceandfire.datagen.tags.IafBlockTags;
import com.github.alexthe666.iceandfire.datagen.tags.IafEntityTags;
import com.github.alexthe666.iceandfire.datagen.tags.IafItemTags;
import com.github.alexthe666.iceandfire.datagen.tags.POITagGenerator;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="iceandfire", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(output, provider);
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new BannerPatternTagGenerator(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new POITagGenerator(output, provider, helper));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)"Resources for Ice and Fire"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0))))));
        generator.addProvider(event.includeServer(), (DataProvider)new IafBiomeTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new AtlasGenerator(output, helper));
        IafBlockTags blocktags = new IafBlockTags(output, provider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blocktags);
        generator.addProvider(event.includeServer(), (DataProvider)new IafItemTags(output, provider, blocktags.m_274426_(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new IafEntityTags(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new IafRecipes(output));
    }
}

