/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage.foundation;

import java.util.function.Supplier;
import net.dadamalda.create_compatible_storage.foundation.PreciseContraptionInteractionStore;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class PreciseContraptionInteractionPacket {
    private final Vec3 hit;

    public PreciseContraptionInteractionPacket(Vec3 hit) {
        this.hit = hit;
    }

    public PreciseContraptionInteractionPacket(FriendlyByteBuf buf) {
        this.hit = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.hit.f_82479_);
        buf.writeDouble(this.hit.f_82480_);
        buf.writeDouble(this.hit.f_82481_);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            PreciseContraptionInteractionStore.storeInteraction(player, this.hit);
        });
        ctx.get().setPacketHandled(true);
    }

    public Vec3 getHit() {
        return this.hit;
    }
}

