/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.light_bulb.network.address;

import com.simibubi.create.content.equipment.clipboard.ClipboardCloneable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import fr.lucreeper74.createmetallurgy.CreateMetallurgy;
import fr.lucreeper74.createmetallurgy.content.blocks.light_bulb.network.INetworkNode;
import fr.lucreeper74.createmetallurgy.content.blocks.light_bulb.network.NetworkHandler;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class NetworkAddressBehaviour
extends BlockEntityBehaviour
implements INetworkNode,
ClipboardCloneable {
    public static final BehaviourType<NetworkAddressBehaviour> TYPE = new BehaviourType();
    ValueBoxTransform slot;
    NetworkHandler.Address address = NetworkHandler.Address.EMPTY;
    private IntSupplier transmission;
    private IntConsumer signalCallback;

    public NetworkAddressBehaviour(SmartBlockEntity be, ValueBoxTransform AddressSlot) {
        super(be);
        this.slot = AddressSlot;
    }

    public static NetworkAddressBehaviour networkNode(SmartBlockEntity be, ValueBoxTransform slot, IntConsumer signalCallback, IntSupplier transmission) {
        NetworkAddressBehaviour behaviour = new NetworkAddressBehaviour(be, slot);
        behaviour.signalCallback = signalCallback;
        behaviour.transmission = transmission;
        return behaviour;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    private NetworkHandler getHandler() {
        return CreateMetallurgy.NETWORK_HANDLER;
    }

    public void setAddress(ItemStack stack) {
        boolean changed;
        stack = stack.m_41777_();
        stack.m_41764_(1);
        boolean bl = changed = !ItemStack.m_41656_((ItemStack)stack, (ItemStack)this.address.getStack());
        if (!changed) {
            return;
        }
        this.getHandler().getNetOf(this.getWorld(), this).removeNode(this);
        this.address = NetworkHandler.Address.of(stack);
        this.blockEntity.sendData();
        this.getHandler().getNetOf(this.getWorld(), this).addNode(this);
    }

    public void unload() {
        super.unload();
        if (this.getWorld().f_46443_) {
            return;
        }
        this.getHandler().getNetOf(this.getWorld(), this).removeNode(this);
    }

    public void notifySignalChange() {
        CreateMetallurgy.NETWORK_HANDLER.getNetOf(this.getWorld(), this).transmit(this);
    }

    public void initialize() {
        super.initialize();
        if (this.getWorld().f_46443_) {
            return;
        }
        this.getHandler().getNetOf(this.getWorld(), this).addNode(this);
    }

    public boolean testHit(Vec3 hit) {
        BlockState state = this.blockEntity.m_58900_();
        Vec3 localHit = hit.m_82546_(Vec3.m_82528_((Vec3i)this.blockEntity.m_58899_()));
        return this.slot.testHit((LevelAccessor)this.getWorld(), this.getPos(), state, localHit);
    }

    @Override
    public boolean isAlive() {
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        if (this.blockEntity.isChunkUnloaded()) {
            return false;
        }
        if (this.blockEntity.m_58901_()) {
            return false;
        }
        if (!level.m_46749_(pos)) {
            return false;
        }
        return level.m_7702_(pos) == this.blockEntity;
    }

    public boolean isSafeNBT() {
        return true;
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.m_128365_("Address", (Tag)this.address.getStack().m_41739_(new CompoundTag()));
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.address = NetworkHandler.Address.of(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Address")));
    }

    @Override
    public int getTransmittedSignal() {
        return this.transmission.getAsInt();
    }

    @Override
    public void setReceivedSignal(int power) {
        this.signalCallback.accept(power);
    }

    @Override
    public BlockPos getLocation() {
        return this.getPos();
    }

    @Override
    public NetworkHandler.Address getAddress() {
        return this.address;
    }

    public String getClipboardKey() {
        return "Address";
    }

    public boolean writeToClipboard(CompoundTag tag, Direction side) {
        tag.m_128365_("AddressClip", (Tag)this.address.getStack().m_41739_(new CompoundTag()));
        return true;
    }

    public boolean readFromClipboard(CompoundTag tag, Player player, Direction side, boolean simulate) {
        if (!tag.m_128441_("AddressClip")) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.setAddress(ItemStack.m_41712_((CompoundTag)tag.m_128469_("AddressClip")));
        return true;
    }
}

