/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.casting;

import com.simibubi.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.basin.CastingBasinBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.table.CastingTableBlockEntity;
import fr.lucreeper74.createmetallurgy.registries.CMBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public enum CastingWithSpout implements BlockSpoutingBehaviour
{
    INSTANCE;


    public int fillBlock(Level level, BlockPos pos, SpoutBlockEntity spout, FluidStack availableFluid, boolean simulate) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return 0;
        }
        IFluidHandler fluidHandler = (IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).orElse(null);
        if (fluidHandler == null) {
            return 0;
        }
        if (fluidHandler.getTanks() != 1) {
            return 0;
        }
        if (!(blockEntity instanceof CastingTableBlockEntity) && !(blockEntity instanceof CastingBasinBlockEntity)) {
            return 0;
        }
        if (!fluidHandler.isFluidValid(0, availableFluid)) {
            return 0;
        }
        FluidStack containedFluid = fluidHandler.getFluidInTank(0);
        if (!containedFluid.isEmpty() && !containedFluid.isFluidEqual(availableFluid)) {
            return 0;
        }
        IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).orElse(null);
        if (itemHandler == null) {
            return 0;
        }
        ItemStack containedItem = itemHandler.getStackInSlot(0);
        if (!containedItem.m_41619_()) {
            return 0;
        }
        int amount = availableFluid.getAmount();
        if (amount < 1000 && fluidHandler.fill(FluidHelper.copyStackWithAmount((FluidStack)availableFluid, (int)(amount + 1)), IFluidHandler.FluidAction.SIMULATE) > amount) {
            return 0;
        }
        return fluidHandler.fill(availableFluid, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    public static void registerDefaults() {
        BlockSpoutingBehaviour.BY_BLOCK_ENTITY.register((Object)((BlockEntityType)CMBlockEntityTypes.CASTING_BASIN.get()), (Object)INSTANCE);
        BlockSpoutingBehaviour.BY_BLOCK_ENTITY.register((Object)((BlockEntityType)CMBlockEntityTypes.CASTING_TABLE.get()), (Object)INSTANCE);
    }
}

