/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.data.compat;

import cn.mcmod_mmf.mmlib.item.IFoodLike;
import cn.mcmod_mmf.mmlib.item.info.FoodInfo;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.compress.utils.Lists;

public class TFCFoodDefinitionProvider
implements DataProvider {
    protected final PackOutput output;
    protected final String modId;
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;
    protected final Map<ResourceLocation, FoodInfo> datas = Maps.newLinkedHashMap();

    public TFCFoodDefinitionProvider(PackOutput output, ExistingFileHelper existingFileHelper, String modId) {
        this.output = output;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", "tfc/food_items");
    }

    public void addData(Item item) {
        if (item instanceof IFoodLike) {
            IFoodLike food = (IFoodLike)item;
            this.addData(item, food.getFoodInfo());
        }
    }

    public void addData(Item item, FoodInfo data) {
        this.datas.computeIfAbsent(ForgeRegistries.ITEMS.getKey((Object)item), loc -> {
            this.existingFileHelper.trackGenerated(loc, this.resourceType);
            return data;
        });
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.datas.clear();
        this.addDatas();
        Path outputFolder = this.output.m_245114_();
        ArrayList futureList = Lists.newArrayList();
        this.datas.forEach((loc, data) -> {
            String pathString = String.join((CharSequence)"/", PackType.SERVER_DATA.m_10305_(), this.modId, "tfc", "food_items", loc.m_135815_() + ".json");
            Path path = outputFolder.resolve(pathString);
            JsonObject jsonObj = new JsonObject();
            jsonObj.add("ingredient", Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(loc)}).m_43942_());
            jsonObj.addProperty("hunger", (Number)data.getAmount());
            jsonObj.addProperty("saturation", (Number)Float.valueOf(data.getCalories()));
            jsonObj.addProperty("decayModifier", (Number)Float.valueOf(data.getDecayModifier()));
            jsonObj.addProperty("water", (Number)Float.valueOf(data.getWater()));
            jsonObj.addProperty("grain", (Number)Float.valueOf(data.getNutrients()[0]));
            jsonObj.addProperty("fruit", (Number)Float.valueOf(data.getNutrients()[1]));
            jsonObj.addProperty("vegetables", (Number)Float.valueOf(data.getNutrients()[2]));
            jsonObj.addProperty("protein", (Number)Float.valueOf(data.getNutrients()[3]));
            jsonObj.addProperty("dairy", (Number)Float.valueOf(data.getNutrients()[4]));
            futureList.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)jsonObj, (Path)path));
        });
        return CompletableFuture.allOf((CompletableFuture[])futureList.stream().toArray(CompletableFuture[]::new));
    }

    public void addDatas() {
    }

    public String m_6055_() {
        return "MMLib FoodInfo to TFC FoodDefinition Provider";
    }
}

