/*
 * Decompiled with CFR 0.152.
 */
package show.tatd.mod.block;

import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.PieBlock;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class CheeseBlock
extends PieBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);

    public CheeseBlock(BlockBehaviour.Properties properties, Supplier<Item> pieSlice) {
        super(properties, pieSlice);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (level.f_46443_) {
            if (heldStack.m_204117_(ModTags.KNIVES)) {
                return this.cutSlice(level, pos, state, player);
            }
            if (this.consumeBite(level, pos, state, player) == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }
            if (heldStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return heldStack.m_204117_(ModTags.KNIVES) ? this.cutSlice(level, pos, state, player) : this.consumeBite(level, pos, state, player);
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int bites;
        if (!playerIn.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getPieSliceItem();
        FoodProperties sliceFood = sliceStack.m_41720_().m_41473_();
        playerIn.m_36324_().m_38712_(sliceStack.m_41720_(), sliceStack);
        if (this.getPieSliceItem().m_41720_().m_41472_() && sliceFood != null) {
            for (Pair pair : sliceFood.m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                playerIn.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        if ((bites = ((Integer)state.m_61143_((Property)BITES)).intValue()) < this.getMaxBites() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        level.m_5594_((Player)null, pos, SoundEvents.f_11969_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (bites < this.getMaxBites() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        Direction direction = player.m_6350_().m_122424_();
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)this.getPieSliceItem(), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        level.m_5594_((Player)null, pos, SoundEvents.f_11969_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

