/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.jei_recipes;

import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.jei_recipes.BakeryJeiPlugin;
import com.renyigesai.bakeries.recipe.oven.OvenRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class OvenRecipeCategory
implements IRecipeCategory<OvenRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("bakeries", "oven_recipe");
    public static final ResourceLocation TEXTURE = new ResourceLocation("bakeries", "textures/gui/jei_oven_gui.png");
    protected final IDrawable background;
    protected final IDrawable icon;
    private final IDrawable cachedArrows;

    public OvenRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 66, 70);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BakeriesBlocks.OVEN.get()));
        this.cachedArrows = helper.createDrawable(TEXTURE, 0, 70, 20, 3);
    }

    public void draw(OvenRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int min_temperature = recipe.getMin_temperature();
        int max_temperature = recipe.getMax_temperature();
        int zhen_min = (500 - min_temperature) / 9 + 9;
        int zhen_max = (500 - max_temperature) / 9 + 9;
        this.cachedArrows.draw(guiGraphics, 38, zhen_min);
        this.cachedArrows.draw(guiGraphics, 38, zhen_max);
        int cookTime = recipe.getTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            guiGraphics.m_280614_(fontRenderer, (Component)timeString, 39 - stringWidth, 31, -8355712, false);
        }
    }

    public @NotNull RecipeType<OvenRecipe> getRecipeType() {
        return BakeryJeiPlugin.Oven_Type;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"container.oven");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, OvenRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 9).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 16, 45).addItemStack(recipe.m_8043_(null));
    }
}

