/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.inventory.dough_crafting_table;

import com.google.common.collect.Lists;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.init.BakeriesMenuType;
import com.renyigesai.bakeries.recipe.DoughCraftingRecipe;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class DoughCraftingTableMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<DoughCraftingRecipe> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.f_41583_;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            DoughCraftingTableMenu.this.m_6199_((Container)this);
            DoughCraftingTableMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public DoughCraftingTableMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.f_39287_);
    }

    public DoughCraftingTableMenu(int pContainerId, Inventory pPlayerInventory, final ContainerLevelAccess pAccess) {
        super((MenuType)BakeriesMenuType.DOUGH_CRAFTING_TABLE_MENU.get(), pContainerId);
        this.access = pAccess;
        this.level = pPlayerInventory.f_35978_.m_9236_();
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(@NotNull ItemStack p_40362_) {
                return false;
            }

            public void m_142406_(@NotNull Player p_150672_, @NotNull ItemStack p_150673_) {
                p_150673_.m_41678_(p_150672_.m_9236_(), p_150672_, p_150673_.m_41613_());
                DoughCraftingTableMenu.this.resultContainer.m_58395_(p_150672_, this.getRelevantItems());
                ItemStack itemstack = DoughCraftingTableMenu.this.inputSlot.m_6201_(1);
                if (!itemstack.m_41619_()) {
                    DoughCraftingTableMenu.this.setupResultSlot();
                }
                pAccess.m_39292_((p_40364_, p_40365_) -> {
                    long l = p_40364_.m_46467_();
                    if (DoughCraftingTableMenu.this.lastSoundTime != l) {
                        p_40364_.m_5594_((Player)null, p_40365_, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        DoughCraftingTableMenu.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(p_150672_, p_150673_);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(DoughCraftingTableMenu.this.inputSlot.m_7993_());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)pPlayerInventory, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        boolean hasItem = this.inputSlot.m_6657_();
        boolean hasRecipes = !this.recipes.isEmpty();
        System.out.println("Has input item: " + hasItem + ", Has recipes: " + hasRecipes);
        return hasItem && hasRecipes;
    }

    public boolean m_6875_(@NotNull Player pPlayer) {
        return DoughCraftingTableMenu.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)BakeriesBlocks.DOUGH_CRAFTING_TABLE.get()));
    }

    public boolean m_6366_(@NotNull Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.selectedRecipeIndex.m_6422_(pId);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.recipes.size();
    }

    public void m_6199_(@NotNull Container pInventory) {
        ItemStack itemstack = this.inputSlot.m_7993_();
        if (!itemstack.m_150930_(this.input.m_41720_())) {
            this.input = itemstack.m_41777_();
            this.setupRecipeList(pInventory, itemstack);
        }
    }

    private void setupRecipeList(Container pContainer, ItemStack pStack) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!pStack.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_((RecipeType)DoughCraftingRecipe.Type.INSTANCE, pContainer, this.level);
            System.out.println("Found recipes: " + this.recipes.size());
        }
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            DoughCraftingRecipe doughCraftingRecipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack itemstack = doughCraftingRecipe.m_5874_(this.container, this.level.m_9598_());
            if (itemstack.m_246617_(this.level.m_246046_())) {
                this.resultContainer.m_6029_((Recipe)doughCraftingRecipe);
                this.resultSlot.m_5852_(itemstack);
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    @NotNull
    public MenuType<?> m_6772_() {
        return (MenuType)BakeriesMenuType.DOUGH_CRAFTING_TABLE_MENU.get();
    }

    public void registerUpdateListener(Runnable pListener) {
        this.slotUpdateListener = pListener;
    }

    public boolean m_5882_(@NotNull ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.resultContainer && super.m_5882_(pStack, pSlot);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            Item item = itemstack1.m_41720_();
            itemstack = itemstack1.m_41777_();
            if (pIndex == 1) {
                item.m_7836_(itemstack1, pPlayer.m_9236_(), pPlayer);
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex == 0 ? !this.m_38903_(itemstack1, 2, 38, false) : (this.level.m_7465_().m_44015_((RecipeType)DoughCraftingRecipe.Type.INSTANCE, (Container)new SimpleContainer(new ItemStack[]{itemstack1}), this.level).isPresent() ? !this.m_38903_(itemstack1, 0, 1, false) : (pIndex >= 2 && pIndex < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : pIndex >= 29 && pIndex < 38 && !this.m_38903_(itemstack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(@NotNull Player pPlayer) {
        super.m_6877_(pPlayer);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((p_40313_, p_40314_) -> this.m_150411_(pPlayer, this.container));
    }

    public List<DoughCraftingRecipe> getRecipes() {
        return this.recipes;
    }
}

