/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.oven;

import com.renyigesai.bakeries.block.oven.OvenBlockEntity;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.init.BakeriesSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OvenBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape S_BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0);
    protected static final VoxelShape S_BOX_B = Block.m_49796_((double)13.5, (double)2.0, (double)12.0, (double)15.5, (double)4.0, (double)12.5);
    protected static final VoxelShape S_BOX_A_1 = Block.m_49796_((double)13.5, (double)6.0, (double)12.0, (double)15.5, (double)8.0, (double)12.5);
    protected static final VoxelShape S_BOX_A_2 = Block.m_49796_((double)1.0, (double)10.0, (double)12.0, (double)13.0, (double)11.0, (double)13.0);
    protected static final VoxelShape N_BASE = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape N_BOX_B = Block.m_49796_((double)0.5, (double)2.0, (double)3.5, (double)2.5, (double)4.0, (double)4.0);
    protected static final VoxelShape N_BOX_A_1 = Block.m_49796_((double)0.5, (double)6.0, (double)3.5, (double)2.5, (double)8.0, (double)4.0);
    protected static final VoxelShape N_BOX_A_2 = Block.m_49796_((double)3.0, (double)10.0, (double)3.0, (double)15.0, (double)11.0, (double)4.0);
    protected static final VoxelShape E_BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
    protected static final VoxelShape E_BOX_B = Block.m_49796_((double)12.0, (double)2.0, (double)0.5, (double)12.5, (double)4.0, (double)2.5);
    protected static final VoxelShape E_BOX_A_1 = Block.m_49796_((double)12.0, (double)6.0, (double)0.5, (double)12.5, (double)8.0, (double)2.5);
    protected static final VoxelShape E_BOX_A_2 = Block.m_49796_((double)2.0, (double)10.0, (double)3.0, (double)13.0, (double)11.0, (double)15.0);
    protected static final VoxelShape W_BASE = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape W_BOX_B = Block.m_49796_((double)3.5, (double)2.0, (double)13.5, (double)4.0, (double)4.0, (double)15.5);
    protected static final VoxelShape W_BOX_A_1 = Block.m_49796_((double)3.5, (double)6.0, (double)13.5, (double)4.0, (double)8.0, (double)15.5);
    protected static final VoxelShape W_BOX_A_2 = Block.m_49796_((double)3.0, (double)10.0, (double)1.0, (double)4.0, (double)11.0, (double)13.0);
    private static final VoxelShape S_AXIS_BAA = Shapes.m_83124_((VoxelShape)S_BASE, (VoxelShape[])new VoxelShape[]{S_BOX_B, S_BOX_A_1, S_BOX_A_2});
    private static final VoxelShape N_AXIS_BAA = Shapes.m_83124_((VoxelShape)N_BASE, (VoxelShape[])new VoxelShape[]{N_BOX_B, N_BOX_A_1, N_BOX_A_2});
    public static final VoxelShape E_AXIS_BAA = Shapes.m_83124_((VoxelShape)E_BASE, (VoxelShape[])new VoxelShape[]{E_BOX_B, E_BOX_A_1, E_BOX_A_2});
    public static final VoxelShape W_AXIS_BAA = Shapes.m_83124_((VoxelShape)W_BASE, (VoxelShape[])new VoxelShape[]{W_BOX_B, W_BOX_A_1, W_BOX_A_2});
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");

    public OvenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)FACING)) {
            default -> N_AXIS_BAA;
            case Direction.NORTH -> S_AXIS_BAA;
            case Direction.EAST -> W_AXIS_BAA;
            case Direction.WEST -> E_AXIS_BAA;
        };
    }

    public int getLightEmission(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            return 5;
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, FACING});
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_8125_();
        BlockPos blockpos = pContext.m_8083_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new OvenBlockEntity(pPos, pState);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : OvenBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)BakeriesBlocks.OVEN_BLOCK_ENTITY.get()), OvenBlockEntity::serverTick);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_8133_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(eventID, eventParam);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockstate, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player entity, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        super.m_6227_(blockstate, world, pos, entity, hand, hit);
        if (!world.m_5776_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            super.m_6227_(blockstate, world, pos, entity, hand, hit);
            if (blockEntity instanceof OvenBlockEntity) {
                OvenBlockEntity ovenBlockEntity = (OvenBlockEntity)blockEntity;
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)entity), (MenuProvider)ovenBlockEntity, (BlockPos)pos);
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    serverLevel.m_247517_(null, pos, (SoundEvent)BakeriesSounds.OVEN_OPEN.get(), SoundSource.BLOCKS);
                }
                return InteractionResult.CONSUME;
            }
            throw new IllegalStateException("Our Container provider is missing!");
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider m_7246_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public void m_6810_(BlockState state, @NotNull Level world, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof OvenBlockEntity) {
                OvenBlockEntity ov = (OvenBlockEntity)blockEntity;
                ov.drops();
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @NotNull
    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public void m_214162_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            double d0 = (double)pPos.m_123341_() + 0.5;
            double d1 = pPos.m_123342_();
            double d2 = (double)pPos.m_123343_() + 0.5;
            if (pRandom.m_188500_() < 0.3) {
                pLevel.m_7785_(d0, d1, d2, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = ((Direction)pState.m_61143_((Property)FACING)).m_122427_();
            Direction.Axis direction$axis = direction.m_122434_();
            for (int i = 0; i < 4; ++i) {
                double d3 = 0.52;
                double d4 = pRandom.m_188500_() * 0.6 - 0.3;
                double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.6 : d4;
                double d6 = pRandom.m_188500_() * 6.0 / 16.0;
                double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.6 : d4;
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean flag;
        if (!pLevel.f_46443_ && (flag = ((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) != pLevel.m_276867_(pPos)) {
            if (flag) {
                pLevel.m_186460_(pPos, (Block)this, 4);
            } else {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)LIT), 2);
            }
        }
    }
}

