/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.menu;

import com.renyigesai.bakeries.block.menu.MenuBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MenuBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public MenuBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> MenuBlock.m_49796_((double)0.0, (double)-8.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.NORTH -> MenuBlock.m_49796_((double)0.0, (double)-8.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
            case Direction.EAST -> MenuBlock.m_49796_((double)15.0, (double)-8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.WEST -> MenuBlock.m_49796_((double)0.0, (double)-8.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
        };
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState pState, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MenuBlockEntity) {
            MenuBlockEntity menuBlockEntity = (MenuBlockEntity)blockEntity;
            ItemStack handStack = pPlayer.m_21120_(pHand);
            if (!handStack.m_41619_()) {
                menuBlockEntity.addItem(handStack.m_41777_().m_41620_(1));
                this.playSound(level, pos, SoundEvents.f_12013_);
                return InteractionResult.SUCCESS;
            }
            if (!menuBlockEntity.inventory.getStackInSlot(0).m_41619_()) {
                if (!pPlayer.m_6144_()) {
                    menuBlockEntity.vertical = !menuBlockEntity.vertical;
                    this.playSound(level, pos, SoundEvents.f_12017_);
                    return InteractionResult.SUCCESS;
                }
                menuBlockEntity.inventory.setStackInSlot(0, ItemStack.f_41583_);
                this.playSound(level, pos, SoundEvents.f_12016_);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.m_6227_(pState, level, pos, pPlayer, pHand, pHit);
    }

    private void playSound(Level level, BlockPos pos, SoundEvent soundEvent) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_247517_(null, pos, soundEvent, SoundSource.BLOCKS);
        }
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MenuBlockEntity(pPos, pState);
    }
}

