/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.api.block.properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ModIntegerProperty
extends Property<Integer> {
    private final ImmutableSet<Integer> values;
    private final int min;
    private final int max;

    protected ModIntegerProperty(String pName, int pMin, int pMax) {
        super(pName, Integer.class);
        if (pMin < 0) {
            throw new IllegalArgumentException("Min value of " + pName + " must be 0 or greater");
        }
        if (pMax <= pMin) {
            throw new IllegalArgumentException("Max value of " + pName + " must be greater than min (" + pMin + ")");
        }
        this.min = pMin;
        this.max = pMax;
        HashSet set = Sets.newHashSet();
        for (int i = pMin; i <= pMax; ++i) {
            set.add(i);
        }
        this.values = ImmutableSet.copyOf((Collection)set);
    }

    @NotNull
    public Collection<Integer> m_6908_() {
        return this.values;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof IntegerProperty && super.equals(pOther)) {
            ModIntegerProperty integerproperty = (ModIntegerProperty)((Object)pOther);
            return this.values.equals(integerproperty.values);
        }
        return false;
    }

    public int m_6310_() {
        return 31 * super.m_6310_() + this.values.hashCode();
    }

    public static ModIntegerProperty create(String pName, int pMin, int pMax) {
        return new ModIntegerProperty(pName, pMin, pMax);
    }

    @NotNull
    public Optional<Integer> m_6215_(@NotNull String pValue) {
        try {
            int integer = Integer.parseInt(pValue);
            return integer >= this.min && integer <= this.max ? Optional.of(integer) : Optional.empty();
        }
        catch (NumberFormatException numberformatexception) {
            return Optional.empty();
        }
    }

    @NotNull
    public String getName(Integer pValue) {
        return pValue.toString();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

