/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.MoveSpeed;
import com.tacz.guns.resource_legacy.CommonGunPackLoader;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ExtraMovementModifier
implements IAttachmentModifier<MoveSpeed, MoveSpeed> {
    public static final String ID = "movement_speed";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<MoveSpeed> readJson(String json) {
        Data data = (Data)CommonGunPackLoader.GSON.fromJson(json, Data.class);
        MoveSpeed moveSpeed = data.getMoveSpeed();
        return new ExtraSpeedJsonProperty(moveSpeed);
    }

    @Override
    public CacheValue<MoveSpeed> initCache(ItemStack gunItem, GunData gunData) {
        return new CacheValue<MoveSpeed>(gunData.getMoveSpeed());
    }

    @Override
    public void eval(List<MoveSpeed> modifiers, CacheValue<MoveSpeed> cache) {
        cache.setValue(MoveSpeed.of(cache.getValue(), modifiers));
    }

    public static class Data {
        @SerializedName(value="movement_speed")
        @Nullable
        private MoveSpeed moveSpeed = null;

        @Nullable
        public MoveSpeed getMoveSpeed() {
            return this.moveSpeed;
        }
    }

    public static class ExtraSpeedJsonProperty
    extends JsonProperty<MoveSpeed> {
        public ExtraSpeedJsonProperty(MoveSpeed value) {
            super(value);
        }

        @Override
        public void initComponents() {
            MoveSpeed speed = (MoveSpeed)this.getValue();
            if (speed == null) {
                return;
            }
            this.resolveComponent(speed.getBaseMultiplier(), ExtraMovementModifier.ID);
            this.resolveComponent(speed.getAimMultiplier(), "aim_speed");
            this.resolveComponent(speed.getReloadMultiplier(), "reload_speed");
        }

        private void resolveComponent(float amount, String key) {
            if (amount > 0.0f) {
                this.components.add(Component.m_237115_((String)String.format("tooltip.tacz.attachment.%s.increase", key)).m_130940_(ChatFormatting.GREEN));
            } else if (amount < 0.0f) {
                this.components.add(Component.m_237115_((String)String.format("tooltip.tacz.attachment.%s.decrease", key)).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

