/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunFireModeAdjustData;
import com.tacz.guns.resource_legacy.CommonGunPackLoader;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AmmoSpeedModifier
implements IAttachmentModifier<Modifier, Float> {
    public static final String ID = "ammo_speed";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Modifier> readJson(String json) {
        Data data = (Data)CommonGunPackLoader.GSON.fromJson(json, Data.class);
        return new BulletSpeedJsonProperty(data.getAmmoSpeed());
    }

    @Override
    public CacheValue<Float> initCache(ItemStack gunItem, GunData gunData) {
        IGun iGun = Objects.requireNonNull(IGun.getIGunOrNull(gunItem));
        FireMode fireMode = iGun.getFireMode(gunItem);
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        float speed = gunData.getBulletData().getSpeed();
        if (fireModeAdjustData != null) {
            speed += fireModeAdjustData.getSpeed();
        }
        return new CacheValue<Float>(Float.valueOf(speed));
    }

    @Override
    public void eval(List<Modifier> modifiers, CacheValue<Float> cache) {
        double eval = AttachmentPropertyManager.eval(modifiers, (double)cache.getValue().floatValue());
        cache.setValue(Float.valueOf((float)eval));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(ItemStack gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        IGun iGun = Objects.requireNonNull(IGun.getIGunOrNull(gunItem));
        FireMode fireMode = iGun.getFireMode(gunItem);
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        float ammoSpeed = gunData.getBulletData().getSpeed();
        if (fireModeAdjustData != null) {
            ammoSpeed += fireModeAdjustData.getSpeed();
        }
        float ammoSpeedModifier = ((Float)cacheProperty.getCache(ID)).floatValue() - ammoSpeed;
        double ammoSpeedPercent = Math.min((double)ammoSpeed / 600.0, 1.0);
        double ammoSpeedModifierPercent = Math.min((double)ammoSpeedModifier / 600.0, 1.0);
        String titleKey = "gui.tacz.gun_refit.property_diagrams.ammo_speed";
        String positivelyString = String.format("%dm/s \u00a7a(+%d)", Math.round(ammoSpeed), Math.round(ammoSpeedModifier));
        String negativelyString = String.format("%dm/s \u00a7c(%d)", Math.round(ammoSpeed), Math.round(ammoSpeedModifier));
        String defaultString = String.format("%dm/s", Math.round(ammoSpeed));
        boolean positivelyBetter = true;
        IAttachmentModifier.DiagramsData diagramsData = new IAttachmentModifier.DiagramsData(ammoSpeedPercent, ammoSpeedModifierPercent, Float.valueOf(ammoSpeedModifier), titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class Data {
        @SerializedName(value="ammo_speed")
        @Nullable
        private Modifier ammoSpeed = null;

        @Nullable
        public Modifier getAmmoSpeed() {
            return this.ammoSpeed;
        }
    }

    public static class BulletSpeedJsonProperty
    extends JsonProperty<Modifier> {
        public BulletSpeedJsonProperty(Modifier value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Modifier ammoSpeed = (Modifier)this.getValue();
            if (ammoSpeed != null) {
                double eval = AttachmentPropertyManager.eval(ammoSpeed, 300.0);
                if (eval > 300.0) {
                    this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.ammo_speed.increase").m_130940_(ChatFormatting.GREEN));
                } else if (eval < 300.0) {
                    this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.ammo_speed.decrease").m_130940_(ChatFormatting.RED));
                }
            }
        }
    }
}

