/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.manager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.manager.INetworkCacheReloadListener;
import com.tacz.guns.resource.network.DataType;
import com.tacz.guns.util.ResourceScanner;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

public class RecipeFilterManager
extends SimplePreparableReloadListener<Map<ResourceLocation, List<JsonElement>>>
implements INetworkCacheReloadListener {
    private final Map<ResourceLocation, RecipeFilter> filters = Maps.newHashMap();
    private final Gson gson = CommonAssetsManager.GSON;
    private final Marker marker = MarkerManager.getMarker((String)"RecipeFilter");
    private final FileToIdConverter fileToIdConverter = FileToIdConverter.m_246568_((String)"recipe_filters");
    protected Map<ResourceLocation, String> networkCache;

    @NotNull
    protected Map<ResourceLocation, List<JsonElement>> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        return ResourceScanner.scanDirectoryAll(pResourceManager, this.fileToIdConverter, this.gson);
    }

    protected void apply(Map<ResourceLocation, List<JsonElement>> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.filters.clear();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, List<JsonElement>> entry : pObject.entrySet()) {
            ResourceLocation id = entry.getKey();
            for (JsonElement element : entry.getValue()) {
                try {
                    RecipeFilter data = this.parseJson(element);
                    this.filters.compute(id, (key, value) -> {
                        if (value == null) {
                            return data;
                        }
                        value.merge(data);
                        return value;
                    });
                }
                catch (JsonParseException e) {
                    GunMod.LOGGER.error(this.marker, "Failed to load data file {}", (Object)id, (Object)e);
                }
            }
            if (!this.filters.containsKey(id)) continue;
            builder.put((Object)id, (Object)this.gson.toJson((Object)this.filters.get(id)));
        }
        this.networkCache = builder.build();
    }

    private RecipeFilter parseJson(JsonElement element) {
        return (RecipeFilter)this.gson.fromJson(element, RecipeFilter.class);
    }

    @Override
    public Map<ResourceLocation, String> getNetworkCache() {
        return this.networkCache;
    }

    @Override
    public DataType getType() {
        return DataType.RECIPE_FILTER;
    }

    public Map<ResourceLocation, RecipeFilter> getFilters() {
        return this.filters;
    }

    public RecipeFilter getFilter(ResourceLocation id) {
        return this.filters.get(id);
    }
}

