/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource;

import com.google.common.collect.Maps;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.tacz.guns.GunMod;
import com.tacz.guns.resource_legacy.CommonGunPackLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public final class VersionChecker {
    private static final Marker MARKER = MarkerManager.getMarker((String)"VersionChecker");
    private static final Pattern PACK_INFO_PATTERN = Pattern.compile("^\\w+/pack\\.json$");
    private static final Map<Path, Boolean> VERSION_CHECK_CACHE = Maps.newHashMap();

    public static boolean match(File dir) {
        return VERSION_CHECK_CACHE.computeIfAbsent(dir.toPath(), path -> VersionChecker.checkDirVersion(dir));
    }

    public static boolean noneMatch(ZipFile zipFile, Path zipFilePath) {
        return VERSION_CHECK_CACHE.computeIfAbsent(zipFilePath, path -> VersionChecker.checkZipVersion(zipFile)) == false;
    }

    public static void clearCache() {
        VERSION_CHECK_CACHE.clear();
    }

    private static boolean checkDirVersion(File root) {
        boolean bl;
        block10: {
            if (!root.isDirectory()) {
                return false;
            }
            Path packInfoFilePath = root.toPath().resolve("pack.json");
            if (Files.notExists(packInfoFilePath, new LinkOption[0])) {
                return true;
            }
            InputStream stream = Files.newInputStream(packInfoFilePath, new OpenOption[0]);
            try {
                Info info = (Info)CommonGunPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), Info.class);
                bl = VersionChecker.modVersionAllMatch(info);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonIOException | JsonSyntaxException | IOException | InvalidVersionSpecificationException exception) {
                    GunMod.LOGGER.warn(MARKER, "Failed to read info json: {}", (Object)packInfoFilePath);
                    GunMod.LOGGER.warn(exception.getMessage());
                    return true;
                }
            }
            stream.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkZipVersion(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> iteration = zipFile.entries();
        while (iteration.hasMoreElements()) {
            String path = iteration.nextElement().getName();
            Matcher matcher = PACK_INFO_PATTERN.matcher(path);
            if (!matcher.matches()) continue;
            ZipEntry entry = zipFile.getEntry(path);
            if (entry == null) {
                return true;
            }
            try {
                InputStream stream = zipFile.getInputStream(entry);
                try {
                    Info info = (Info)CommonGunPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), Info.class);
                    if (VersionChecker.modVersionAllMatch(info)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (JsonIOException | JsonSyntaxException | IOException | InvalidVersionSpecificationException exception) {
                GunMod.LOGGER.warn(MARKER, "Failed to read info json: {}", (Object)path);
                GunMod.LOGGER.warn(exception.getMessage());
            }
        }
        return true;
    }

    private static boolean modVersionAllMatch(Info info) throws InvalidVersionSpecificationException {
        HashMap<String, String> dependencies = info.getDependencies();
        for (String modId : dependencies.keySet()) {
            if (VersionChecker.modVersionMatch(modId, dependencies.get(modId))) continue;
            return false;
        }
        return true;
    }

    private static boolean modVersionMatch(String modId, String version) throws InvalidVersionSpecificationException {
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)version);
        return ModList.get().getModContainerById(modId).map(mod -> {
            ArtifactVersion modVersion = mod.getModInfo().getVersion();
            return versionRange.containsVersion(modVersion);
        }).orElse(false);
    }

    private static class Info {
        @SerializedName(value="dependencies")
        private HashMap<String, String> dependencies = Maps.newHashMap();

        private Info() {
        }

        public HashMap<String, String> getDependencies() {
            return this.dependencies;
        }
    }
}

