/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.util.LuaEntityAccessor;
import com.tacz.guns.api.util.LuaNbtAccessor;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunFire;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.InaccuracyType;
import com.tacz.guns.sound.SoundManager;
import com.tacz.guns.util.AttachmentDataUtils;
import com.tacz.guns.util.CycleTaskHelper;
import it.unimi.dsi.fastutil.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class ModernKineticGunScriptAPI {
    public static String MARKER = "ScriptAPI";
    private LivingEntity shooter;
    private ShooterDataHolder dataHolder;
    private ItemStack itemStack;
    private AbstractGunItem abstractGunItem;
    private CommonGunIndex gunIndex;
    private ResourceLocation gunId;
    private ResourceLocation gunDisplayId;
    private Supplier<Float> pitchSupplier;
    private Supplier<Float> yawSupplier;
    private LuaNbtAccessor nbtUtil;
    private LuaEntityAccessor entityAccessor;

    public void shootOnce(boolean consumeAmmo) {
        GunData gunData = this.gunIndex.getGunData();
        BulletData bulletData = this.gunIndex.getBulletData();
        IGunOperator gunOperator = IGunOperator.fromLivingEntity(this.shooter);
        AttachmentCacheProperty cacheProperty = gunOperator.getCacheProperty();
        if (cacheProperty == null) {
            return;
        }
        InaccuracyType inaccuracyType = InaccuracyType.getInaccuracyType(this.shooter);
        float inaccuracy = Math.max(0.0f, ((Float)((Map)cacheProperty.getCache("inaccuracy")).get((Object)inaccuracyType)).floatValue());
        if (inaccuracyType == InaccuracyType.AIM) {
            inaccuracy = Math.max(0.0f, ((Float)((Map)cacheProperty.getCache("aim_inaccuracy")).get((Object)inaccuracyType)).floatValue());
        }
        float finalInaccuracy = inaccuracy;
        Pair silence = (Pair)cacheProperty.getCache("silence");
        int soundDistance = (Integer)silence.first();
        boolean useSilenceSound = (Boolean)silence.right();
        float speed = ((Float)cacheProperty.getCache("ammo_speed")).floatValue();
        float processedSpeed = Mth.m_14036_((float)(speed / 20.0f), (float)0.0f, (float)Float.MAX_VALUE);
        int bulletAmount = Math.max(bulletData.getBulletAmount(), 1);
        FireMode fireMode = this.abstractGunItem.getFireMode(this.itemStack);
        int cycles = fireMode == FireMode.BURST ? gunData.getBurstData().getCount() : 1;
        long period = fireMode == FireMode.BURST ? gunData.getBurstShootInterval() : 1L;
        CycleTaskHelper.addCycleTask(() -> {
            boolean fire;
            if (this.shooter.m_21224_()) {
                return false;
            }
            if (!this.shooter.m_21205_().equals(this.itemStack) || this.shooter.m_21205_().m_41619_()) {
                return false;
            }
            boolean bl = fire = !MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent(this.shooter, this.itemStack, LogicalSide.SERVER));
            if (fire) {
                NetworkHandler.sendToTrackingEntity(new ServerMessageGunFire(this.shooter.m_19879_(), this.itemStack), (Entity)this.shooter);
                if (consumeAmmo && !this.reduceAmmoOnce()) {
                    return false;
                }
                float pitch = this.pitchSupplier != null ? this.pitchSupplier.get().floatValue() : this.shooter.m_146909_();
                float yaw = this.yawSupplier != null ? this.yawSupplier.get().floatValue() : this.shooter.m_146908_();
                Level world = this.shooter.m_9236_();
                ResourceLocation ammoId = gunData.getAmmoId();
                for (int i = 0; i < bulletAmount; ++i) {
                    boolean isTracer = bulletData.hasTracerAmmo() && gunOperator.nextBulletIsTracer(bulletData.getTracerCountInterval());
                    EntityKineticBullet bullet = new EntityKineticBullet(world, this.shooter, this.itemStack, ammoId, this.gunId, isTracer, gunData, bulletData);
                    bullet.m_37251_((Entity)bullet, pitch, yaw, 0.0f, processedSpeed, finalInaccuracy);
                    world.m_7967_((Entity)bullet);
                }
                if (soundDistance > 0) {
                    String soundId = useSilenceSound ? SoundManager.SILENCE_3P_SOUND : SoundManager.SHOOT_3P_SOUND;
                    SoundManager.sendSoundToNearby(this.shooter, soundDistance, this.gunId, this.gunDisplayId, soundId, 0.8f, 0.9f + this.shooter.m_217043_().m_188501_() * 0.125f);
                }
            }
            return true;
        }, period, cycles);
    }

    public boolean reduceAmmoOnce() {
        Bolt boltType = TimelessAPI.getCommonGunIndex(this.abstractGunItem.getGunId(this.itemStack)).map(index -> index.getGunData().getBolt()).orElse(null);
        if (boltType == null) {
            return false;
        }
        if (boltType == Bolt.MANUAL_ACTION) {
            if (!this.abstractGunItem.hasBulletInBarrel(this.itemStack)) {
                return false;
            }
            this.abstractGunItem.setBulletInBarrel(this.itemStack, false);
        } else if (boltType == Bolt.CLOSED_BOLT) {
            if (this.abstractGunItem.getCurrentAmmoCount(this.itemStack) > 0) {
                this.abstractGunItem.reduceCurrentAmmoCount(this.itemStack);
            } else {
                if (!this.abstractGunItem.hasBulletInBarrel(this.itemStack)) {
                    return false;
                }
                this.abstractGunItem.setBulletInBarrel(this.itemStack, false);
            }
        } else {
            if (this.abstractGunItem.getCurrentAmmoCount(this.itemStack) == 0) {
                return false;
            }
            this.abstractGunItem.reduceCurrentAmmoCount(this.itemStack);
        }
        return true;
    }

    public long getReloadTime() {
        if (this.dataHolder.reloadTimestamp == -1L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.dataHolder.reloadTimestamp;
    }

    public long getBoltTime() {
        if (!this.dataHolder.isBolting) {
            return 0L;
        }
        return System.currentTimeMillis() - this.dataHolder.boltTimestamp;
    }

    public long getShootInterval() {
        FireMode fireMode = this.abstractGunItem.getFireMode(this.itemStack);
        if (fireMode == FireMode.BURST) {
            long coolDown = (long)(this.gunIndex.getGunData().getBurstData().getMinInterval() * 1000.0);
            return Math.max(coolDown -= 5L, 0L);
        }
        long coolDown = this.gunIndex.getGunData().getShootInterval(this.shooter, fireMode);
        return Math.max(coolDown -= 5L, 0L);
    }

    public long getLastShootTimestamp() {
        return this.dataHolder.lastShootTimestamp + this.dataHolder.baseTimestamp;
    }

    public void adjustShootInterval(long alpha) {
        this.dataHolder.shootTimestamp += alpha;
    }

    public void adjustReloadTime(long alpha) {
        this.dataHolder.reloadTimestamp -= alpha;
    }

    public void adjustBoltTime(long alpha) {
        this.dataHolder.boltTimestamp -= alpha;
    }

    public float getAimingProgress() {
        return this.dataHolder.aimingProgress;
    }

    public int getReloadStateType() {
        return this.dataHolder.reloadStateType.ordinal();
    }

    public int getFireMode() {
        return this.abstractGunItem.getFireMode(this.itemStack).ordinal();
    }

    public boolean isShootingNeedConsumeAmmo() {
        return IGunOperator.fromLivingEntity(this.shooter).consumesAmmoOrNot();
    }

    public boolean isReloadingNeedConsumeAmmo() {
        return IGunOperator.fromLivingEntity(this.shooter).needCheckAmmo();
    }

    public int getNeededAmmoAmount() {
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(this.itemStack, this.gunIndex.getGunData());
        int currentAmmoCount = this.abstractGunItem.getCurrentAmmoCount(this.itemStack);
        return maxAmmoCount - currentAmmoCount;
    }

    public int getAmmoAmount() {
        return this.abstractGunItem.getCurrentAmmoCount(this.itemStack);
    }

    public int getMaxAmmoCount() {
        return AttachmentDataUtils.getAmmoCountWithAttachment(this.itemStack, this.gunIndex.getGunData());
    }

    public int getMagExtentLevel() {
        return AttachmentDataUtils.getMagExtendLevel(this.itemStack, this.gunIndex.getGunData());
    }

    public int consumeAmmoFromPlayer(int neededAmount) {
        if (this.abstractGunItem.useDummyAmmo(this.itemStack)) {
            return this.abstractGunItem.findAndExtractDummyAmmo(this.itemStack, neededAmount);
        }
        return this.shooter.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(cap -> this.abstractGunItem.findAndExtractInventoryAmmos((IItemHandler)cap, this.itemStack, neededAmount)).orElse(0);
    }

    public boolean hasAmmoToConsume() {
        if (!this.isReloadingNeedConsumeAmmo()) {
            return true;
        }
        if (this.abstractGunItem.useDummyAmmo(this.itemStack)) {
            return this.abstractGunItem.getDummyAmmoAmount(this.itemStack) > 0;
        }
        return this.shooter.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                IAmmoBox iAmmoBox;
                IAmmo iAmmo;
                ItemStack checkAmmoStack = cap.getStackInSlot(i);
                Item patt13615$temp = checkAmmoStack.m_41720_();
                if (patt13615$temp instanceof IAmmo && (iAmmo = (IAmmo)patt13615$temp).isAmmoOfGun(this.itemStack, checkAmmoStack)) {
                    return true;
                }
                Item patt13788$temp = checkAmmoStack.m_41720_();
                if (!(patt13788$temp instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)patt13788$temp).isAmmoBoxOfGun(this.itemStack, checkAmmoStack)) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public int putAmmoInMagazine(int amount) {
        int currentAmmoCount;
        int newAmmoCount;
        if (amount < 0) {
            return 0;
        }
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(this.itemStack, this.gunIndex.getGunData());
        if (maxAmmoCount < (newAmmoCount = (currentAmmoCount = this.abstractGunItem.getCurrentAmmoCount(this.itemStack)) + amount)) {
            this.abstractGunItem.setCurrentAmmoCount(this.itemStack, maxAmmoCount);
            return newAmmoCount - maxAmmoCount;
        }
        this.abstractGunItem.setCurrentAmmoCount(this.itemStack, newAmmoCount);
        return 0;
    }

    public int removeAmmoFromMagazine(int amount) {
        if (amount < 0) {
            return 0;
        }
        int currentAmmoCount = this.abstractGunItem.getCurrentAmmoCount(this.itemStack);
        if (currentAmmoCount < amount) {
            this.abstractGunItem.setCurrentAmmoCount(this.itemStack, 0);
            return currentAmmoCount;
        }
        this.abstractGunItem.setCurrentAmmoCount(this.itemStack, currentAmmoCount - amount);
        return amount;
    }

    public int getAmmoCountInMagazine() {
        return this.abstractGunItem.getCurrentAmmoCount(this.itemStack);
    }

    public boolean hasAmmoInBarrel() {
        Bolt boltType = this.gunIndex.getGunData().getBolt();
        return boltType != Bolt.OPEN_BOLT && this.abstractGunItem.hasBulletInBarrel(this.itemStack);
    }

    public void setAmmoInBarrel(boolean ammoInBarrel) {
        this.abstractGunItem.setBulletInBarrel(this.itemStack, ammoInBarrel);
    }

    public void cacheScriptData(LuaValue luaValue) {
        this.dataHolder.scriptData = luaValue;
    }

    public LuaValue getCachedScriptData() {
        return this.dataHolder.scriptData;
    }

    public LuaTable getScriptParams() {
        LuaTable param = this.gunIndex.getScriptParam();
        return param == null ? new LuaTable() : param;
    }

    public void safeAsyncTask(LuaValue value, long delayMs, long periodMs, int cycles) {
        LuaFunction func = value.checkfunction();
        CycleTaskHelper.addCycleTask(() -> func.call().checkboolean(), delayMs, periodMs, cycles);
    }

    public long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    public String getAttachment(String type) {
        try {
            AttachmentType t = AttachmentType.valueOf(type);
            return this.abstractGunItem.getAttachmentId(this.itemStack, t).toString();
        }
        catch (IllegalArgumentException e) {
            return DefaultAssets.EMPTY_ATTACHMENT_ID.toString();
        }
    }

    public LuaNbtAccessor getNbt() {
        return this.nbtUtil;
    }

    public LuaEntityAccessor getEntityUtil() {
        if (this.entityAccessor == null) {
            this.entityAccessor = new LuaEntityAccessor(this.shooter);
        }
        return this.entityAccessor;
    }

    public void setShooter(LivingEntity shooter) {
        this.shooter = shooter;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.initGunItem();
    }

    public void setPitchSupplier(Supplier<Float> pitchSupplier) {
        this.pitchSupplier = pitchSupplier;
    }

    public void setYawSupplier(Supplier<Float> yawSupplier) {
        this.yawSupplier = yawSupplier;
    }

    public LivingEntity getShooter() {
        return this.shooter;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public AbstractGunItem getAbstractGunItem() {
        return this.abstractGunItem;
    }

    public CommonGunIndex getGunIndex() {
        return this.gunIndex;
    }

    public void setDataHolder(ShooterDataHolder dataHolder) {
        this.dataHolder = dataHolder;
    }

    ShooterDataHolder getDataHolder() {
        return this.dataHolder;
    }

    private void initGunItem() {
        Item item;
        if (this.itemStack == null || !((item = this.itemStack.m_41720_()) instanceof AbstractGunItem)) {
            this.gunIndex = null;
            this.abstractGunItem = null;
            return;
        }
        AbstractGunItem gunItem = (AbstractGunItem)item;
        this.gunId = gunItem.getGunId(this.itemStack);
        this.gunDisplayId = gunItem.getGunDisplayId(this.itemStack);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(this.gunId);
        this.gunIndex = gunIndexOptional.orElse(null);
        this.abstractGunItem = gunItem;
        if (this.itemStack.m_41782_()) {
            this.nbtUtil = new LuaNbtAccessor(this.itemStack.m_41783_());
        }
    }
}

