/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.pojo.data.gun.MoveSpeed;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public class LivingEntitySpeedModifier {
    private static final UUID EXTRA_SPEED_MODIFIER_UUID = UUID.fromString("4D5696AE-A7C5-C59C-80E9-2A2DC8373C46");
    private static final UUID WEIGHT_SPEED_MODIFIER_UUID = UUID.fromString("2CB6F5AD-C6D2-9D29-4E84-0856ACD47CDB");
    private final LivingEntity shooter;
    private final ShooterDataHolder dataHolder;

    public LivingEntitySpeedModifier(LivingEntity shooter, ShooterDataHolder dataHolder) {
        this.shooter = shooter;
        this.dataHolder = dataHolder;
    }

    public void updateSpeedModifier() {
        if (!this.shooter.m_6084_()) {
            return;
        }
        ItemStack stack = this.shooter.m_21205_();
        AttributeInstance speedModifier = this.shooter.m_21204_().m_22146_(Attributes.f_22279_);
        if (speedModifier == null) {
            return;
        }
        if (stack.m_41720_() instanceof AbstractGunItem) {
            AttachmentCacheProperty cacheProperty = IGunOperator.fromLivingEntity(this.shooter).getCacheProperty();
            if (cacheProperty != null) {
                MoveSpeed speed;
                double weightFactor = (Double)SyncConfig.WEIGHT_SPEED_MULTIPLIER.get();
                if (weightFactor > 0.0) {
                    float targetSpeed = ((Float)cacheProperty.getCache("weight_modifier")).floatValue();
                    AttributeModifier currentModifier = speedModifier.m_22111_(WEIGHT_SPEED_MODIFIER_UUID);
                    if (currentModifier == null || currentModifier.m_22218_() != (double)(targetSpeed *= (float)(-weightFactor))) {
                        speedModifier.m_22120_(WEIGHT_SPEED_MODIFIER_UUID);
                        speedModifier.m_22118_(new AttributeModifier(WEIGHT_SPEED_MODIFIER_UUID, "Gun Speed Modifier", (double)targetSpeed, AttributeModifier.Operation.MULTIPLY_BASE));
                    }
                }
                if ((speed = (MoveSpeed)cacheProperty.getCache("movement_speed")) != null) {
                    double targetSpeed = this.getTargetSpeed(speed);
                    AttributeModifier currentModifier = speedModifier.m_22111_(EXTRA_SPEED_MODIFIER_UUID);
                    if (currentModifier == null || currentModifier.m_22218_() != targetSpeed) {
                        speedModifier.m_22120_(EXTRA_SPEED_MODIFIER_UUID);
                        speedModifier.m_22118_(new AttributeModifier(EXTRA_SPEED_MODIFIER_UUID, "Extra Gun Speed Modifier", targetSpeed, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    }
                }
            }
        } else {
            speedModifier.m_22120_(WEIGHT_SPEED_MODIFIER_UUID);
            speedModifier.m_22120_(EXTRA_SPEED_MODIFIER_UUID);
        }
    }

    private double getTargetSpeed(MoveSpeed moveSpeed) {
        if (this.dataHolder.reloadStateType.isReloading()) {
            return moveSpeed.getReloadMultiplier();
        }
        if (this.dataHolder.isAiming) {
            return moveSpeed.getAimMultiplier();
        }
        return moveSpeed.getBaseMultiplier();
    }
}

