/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.sound;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.sound.GunSoundInstance;
import com.tacz.guns.config.common.GunConfig;
import com.tacz.guns.init.ModSounds;
import com.tacz.guns.network.message.ServerMessageSound;
import com.tacz.guns.sound.SoundManager;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SoundPlayManager {
    private static boolean DRY_SOUND_TRACK = true;
    private static GunSoundInstance tmpSoundInstance = null;

    public static GunSoundInstance playClientSound(Entity entity, @Nullable ResourceLocation name, float volume, float pitch, int distance, boolean mono) {
        Minecraft minecraft = Minecraft.m_91087_();
        GunSoundInstance instance = new GunSoundInstance((SoundEvent)ModSounds.GUN.get(), SoundSource.PLAYERS, volume, pitch, entity, distance, name, mono);
        minecraft.m_91106_().m_120367_((SoundInstance)instance);
        return instance;
    }

    public static GunSoundInstance playClientSound(Entity entity, @Nullable ResourceLocation name, float volume, float pitch, int distance) {
        return SoundPlayManager.playClientSound(entity, name, volume, pitch, distance, false);
    }

    public static void stopPlayGunSound() {
        if (tmpSoundInstance != null) {
            tmpSoundInstance.setStop();
        }
    }

    public static void stopPlayGunSound(GunDisplayInstance gunIndex, String animationName) {
        if (tmpSoundInstance != null && tmpSoundInstance.getRegistryName() != null && tmpSoundInstance.getRegistryName().equals((Object)gunIndex.getSounds(animationName))) {
            tmpSoundInstance.setStop();
        }
    }

    public static void playerRefitSound(ItemStack attachmentItem, LocalPlayer player, String soundName) {
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachmentItem);
        if (iAttachment == null) {
            return;
        }
        ResourceLocation attachmentId = iAttachment.getAttachmentId(attachmentItem);
        TimelessAPI.getClientAttachmentIndex(attachmentId).ifPresent(index -> {
            Map<String, ResourceLocation> sounds = index.getSounds();
            if (sounds.containsKey(soundName)) {
                ResourceLocation resourceLocation = sounds.get(soundName);
                SoundPlayManager.playClientSound((Entity)player, resourceLocation, 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
            }
        });
    }

    public static void playShootSound(LivingEntity entity, GunDisplayInstance gunIndex) {
        SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.SHOOT_SOUND), 0.8f, 0.9f + entity.m_217043_().m_188501_() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_FIRE_SOUND_DISTANCE.get());
    }

    public static void playSilenceSound(LivingEntity entity, GunDisplayInstance gunIndex) {
        SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.SILENCE_SOUND), 0.6f, 0.9f + entity.m_217043_().m_188501_() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playDryFireSound(LivingEntity entity, GunDisplayInstance gunIndex) {
        if (DRY_SOUND_TRACK) {
            SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.DRY_FIRE_SOUND), 1.0f, 0.9f + entity.m_217043_().m_188501_() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
            DRY_SOUND_TRACK = false;
        }
    }

    public static void resetDryFireSound() {
        DRY_SOUND_TRACK = true;
    }

    public static void playReloadSound(LivingEntity entity, GunDisplayInstance display, boolean noAmmo) {
        tmpSoundInstance = noAmmo ? SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.RELOAD_EMPTY_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get()) : SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.RELOAD_TACTICAL_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playInspectSound(LivingEntity entity, GunDisplayInstance display, boolean noAmmo) {
        tmpSoundInstance = noAmmo ? SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.INSPECT_EMPTY_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get()) : SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.INSPECT_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playBoltSound(LivingEntity entity, GunDisplayInstance display) {
        tmpSoundInstance = SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.BOLT_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playDrawSound(LivingEntity entity, GunDisplayInstance display) {
        tmpSoundInstance = SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.DRAW_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playPutAwaySound(LivingEntity entity, GunDisplayInstance display) {
        tmpSoundInstance = SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.PUT_AWAY_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playFireSelectSound(LivingEntity entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.FIRE_SELECT), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playMeleeBayonetSound(LivingEntity entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.MELEE_BAYONET), 1.0f, 0.9f + entity.m_217043_().m_188501_() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playMeleePushSound(LivingEntity entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.MELEE_PUSH), 1.0f, 0.9f + entity.m_217043_().m_188501_() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playMeleeStockSound(LivingEntity entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.MELEE_STOCK), 1.0f, 0.9f + entity.m_217043_().m_188501_() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playHeadHitSound(LivingEntity entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.HEAD_HIT_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playFleshHitSound(LivingEntity entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.FLESH_HIT_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playKillSound(LivingEntity entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((Entity)entity, display.getSounds(SoundManager.KILL_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playMessageSound(ServerMessageSound message) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null || !((entity = level.m_6815_(message.getEntityId())) instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ResourceLocation gunId = message.getGunId();
        ResourceLocation gunDisplayId = message.getGunDisplayId();
        TimelessAPI.getGunDisplay(gunDisplayId, gunId).ifPresent(index -> {
            String soundName = message.getSoundName();
            ResourceLocation soundId = index.getSounds(soundName);
            if (soundId == null) {
                return;
            }
            if (SoundManager.SHOOT_3P_SOUND.equals(soundName) || SoundManager.SILENCE_3P_SOUND.equals(soundName)) {
                SoundPlayManager.playClientSound((Entity)livingEntity, soundId, message.getVolume(), message.getPitch(), message.getDistance(), true);
            } else {
                SoundPlayManager.playClientSound((Entity)livingEntity, soundId, message.getVolume(), message.getPitch(), message.getDistance());
            }
        });
    }
}

