/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource_legacy.loader.asset;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.pojo.display.gun.GunDisplay;
import com.tacz.guns.client.resource_legacy.ClientAssetManager;
import com.tacz.guns.client.resource_legacy.ClientGunPackLoader;
import com.tacz.guns.util.TacPathVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class GunDisplayLoader {
    private static final Marker MARKER = MarkerManager.getMarker((String)"GunDisplayLoader");
    private static final Pattern DISPLAY_PATTERN = Pattern.compile("^(\\w+)/guns/display/([\\w/]+)\\.json$");

    public static boolean load(ZipFile zipFile, String zipPath) {
        Matcher matcher = DISPLAY_PATTERN.matcher(zipPath);
        if (matcher.find()) {
            boolean bl;
            block10: {
                String namespace = matcher.group(1);
                String path = matcher.group(2);
                ZipEntry entry = zipFile.getEntry(zipPath);
                if (entry == null) {
                    GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)zipPath);
                    return false;
                }
                InputStream stream = zipFile.getInputStream(entry);
                try {
                    ResourceLocation registryName = new ResourceLocation(namespace, path);
                    GunDisplay display = (GunDisplay)ClientGunPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), GunDisplay.class);
                    ClientAssetManager.INSTANCE.putGunDisplay(registryName, display);
                    bl = true;
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException exception) {
                        GunMod.LOGGER.warn(MARKER, "Failed to read display file: {}, entry: {}", (Object)zipFile, (Object)entry);
                        exception.printStackTrace();
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    public static void load(File root) {
        Path displayPath = root.toPath().resolve("guns/display");
        if (Files.isDirectory(displayPath, new LinkOption[0])) {
            TacPathVisitor visitor = new TacPathVisitor(displayPath.toFile(), root.getName(), ".json", (id, file) -> {
                try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                    GunDisplay display = (GunDisplay)ClientGunPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), GunDisplay.class);
                    ClientAssetManager.INSTANCE.putGunDisplay((ResourceLocation)id, display);
                }
                catch (JsonIOException | JsonSyntaxException | IOException exception) {
                    GunMod.LOGGER.warn(MARKER, "Failed to read display file: {}", file);
                    exception.printStackTrace();
                }
            });
            try {
                Files.walkFileTree(displayPath, visitor);
            }
            catch (IOException e) {
                GunMod.LOGGER.warn(MARKER, "Failed to walk file tree: {}", (Object)displayPath);
                e.printStackTrace();
            }
        }
    }
}

