/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource_legacy;

import com.google.common.collect.Maps;
import com.tacz.guns.api.client.animation.gltf.AnimationStructure;
import com.tacz.guns.client.model.BedrockAttachmentModel;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.manager.SoundAssetsManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.client.resource.pojo.animation.bedrock.BedrockAnimationFile;
import com.tacz.guns.client.resource.pojo.display.ammo.AmmoDisplay;
import com.tacz.guns.client.resource.pojo.display.attachment.AttachmentDisplay;
import com.tacz.guns.client.resource.pojo.display.block.BlockDisplay;
import com.tacz.guns.client.resource.pojo.display.gun.GunDisplay;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import com.tacz.guns.client.resource.pojo.skin.attachment.AttachmentSkin;
import com.tacz.guns.compat.playeranimator.PlayerAnimatorCompat;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.luaj.vm2.LuaTable;

@OnlyIn(value=Dist.CLIENT)
@Deprecated
public enum ClientAssetManager {
    INSTANCE;

    private final Map<String, PackInfo> customInfos = Maps.newHashMap();
    private final Map<ResourceLocation, GunDisplay> gunDisplays = Maps.newHashMap();
    private final Map<ResourceLocation, AmmoDisplay> ammoDisplays = Maps.newHashMap();
    private final Map<ResourceLocation, AttachmentDisplay> attachmentDisplays = Maps.newHashMap();
    private final Map<ResourceLocation, BlockDisplay> blockDisplays = Maps.newHashMap();
    private final Map<ResourceLocation, Map<ResourceLocation, AttachmentSkin>> attachmentSkins = Maps.newHashMap();
    private final Map<ResourceLocation, AnimationStructure> gltfAnimations = Maps.newHashMap();
    private final Map<ResourceLocation, BedrockAnimationFile> bedrockAnimations = Maps.newHashMap();
    private final Map<ResourceLocation, BedrockModelPOJO> models = Maps.newHashMap();
    private final Map<ResourceLocation, SoundAssetsManager.SoundData> soundBuffers = Maps.newHashMap();
    private final Map<String, Map<String, String>> languages = Maps.newHashMap();
    private final Map<ResourceLocation, BedrockAttachmentModel> tempAttachmentModelMap = Maps.newHashMap();
    private final Map<ResourceLocation, BedrockGunModel> tempGunModelMap = Maps.newHashMap();
    private final Map<ResourceLocation, LuaTable> scriptsMap = Maps.newHashMap();

    @Nullable
    private static BedrockAttachmentModel getAttachmentModel(BedrockModelPOJO modelPOJO) {
        BedrockAttachmentModel attachmentModel = null;
        if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
            attachmentModel = new BedrockAttachmentModel(modelPOJO, BedrockVersion.LEGACY);
        }
        if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
            attachmentModel = new BedrockAttachmentModel(modelPOJO, BedrockVersion.NEW);
        }
        return attachmentModel;
    }

    public void putPackInfo(String namespace, PackInfo info) {
        this.customInfos.put(namespace, info);
    }

    public void putGunDisplay(ResourceLocation registryName, GunDisplay display) {
        this.gunDisplays.put(registryName, display);
    }

    public void putAmmoDisplay(ResourceLocation registryName, AmmoDisplay display) {
        this.ammoDisplays.put(registryName, display);
    }

    public void putAttachmentDisplay(ResourceLocation registryName, AttachmentDisplay display) {
        this.attachmentDisplays.put(registryName, display);
    }

    public void putBlockDisplay(ResourceLocation registryName, BlockDisplay display) {
        this.blockDisplays.put(registryName, display);
    }

    public void putAttachmentSkin(ResourceLocation registryName, AttachmentSkin skin) {
        this.attachmentSkins.compute(skin.getParent(), (name, map) -> {
            if (map == null) {
                map = Maps.newHashMap();
            }
            map.put(registryName, skin);
            return map;
        });
    }

    public void putGltfAnimation(ResourceLocation registryName, AnimationStructure animation) {
        this.gltfAnimations.put(registryName, animation);
    }

    public void putBedrockAnimation(ResourceLocation registryName, BedrockAnimationFile bedrockAnimationFile) {
        this.bedrockAnimations.put(registryName, bedrockAnimationFile);
    }

    public void putModel(ResourceLocation registryName, BedrockModelPOJO model) {
        this.models.put(registryName, model);
    }

    public void putSoundBuffer(ResourceLocation registryName, SoundAssetsManager.SoundData soundData) {
        this.soundBuffers.put(registryName, soundData);
    }

    public void putLanguage(String region, Map<String, String> lang) {
        Map<String, String> languageMaps = this.languages.getOrDefault(region, Maps.newHashMap());
        languageMaps.putAll(lang);
        this.languages.put(region, languageMaps);
    }

    public void putScript(ResourceLocation registryName, LuaTable luaTable) {
        this.scriptsMap.put(registryName, luaTable);
    }

    public BlockDisplay getBlockDisplays(ResourceLocation registryName) {
        return this.blockDisplays.get(registryName);
    }

    public GunDisplay getGunDisplay(ResourceLocation registryName) {
        return ClientAssetsManager.INSTANCE.getGunDisplay(registryName);
    }

    public AmmoDisplay getAmmoDisplay(ResourceLocation registryName) {
        return this.ammoDisplays.get(registryName);
    }

    @Nullable
    public AttachmentDisplay getAttachmentDisplay(ResourceLocation registryName) {
        return this.attachmentDisplays.get(registryName);
    }

    public Map<ResourceLocation, AttachmentSkin> getAttachmentSkins(ResourceLocation registryName) {
        return this.attachmentSkins.get(registryName);
    }

    public AnimationStructure getGltfAnimations(ResourceLocation registryName) {
        return ClientAssetsManager.INSTANCE.getGltfAnimation(registryName);
    }

    public BedrockAnimationFile getBedrockAnimations(ResourceLocation registryName) {
        return ClientAssetsManager.INSTANCE.getBedrockAnimations(registryName);
    }

    public SoundAssetsManager.SoundData getSoundBuffers(ResourceLocation registryName) {
        return this.soundBuffers.get(registryName);
    }

    public Map<String, String> getLanguages(String region) {
        return this.languages.get(region);
    }

    @Nullable
    public PackInfo getPackInfo(ResourceLocation id) {
        return this.customInfos.get(id.m_135827_());
    }

    @Nullable
    public BedrockAttachmentModel getOrLoadAttachmentModel(@Nullable ResourceLocation modelLocation) {
        if (modelLocation == null) {
            return null;
        }
        BedrockAttachmentModel model = this.tempAttachmentModelMap.get(modelLocation);
        if (model != null) {
            return model;
        }
        BedrockModelPOJO modelPOJO = ClientAssetsManager.INSTANCE.getBedrockModelPOJO(modelLocation);
        if (modelPOJO == null) {
            return null;
        }
        BedrockAttachmentModel attachmentModel = ClientAssetManager.getAttachmentModel(modelPOJO);
        if (attachmentModel == null) {
            return null;
        }
        this.tempAttachmentModelMap.put(modelLocation, attachmentModel);
        return attachmentModel;
    }

    public LuaTable getScript(ResourceLocation registryName) {
        return ClientAssetsManager.INSTANCE.getScript(registryName);
    }

    public void clearAll() {
        this.customInfos.clear();
        this.gunDisplays.clear();
        this.ammoDisplays.clear();
        this.attachmentDisplays.clear();
        this.attachmentSkins.clear();
        this.gltfAnimations.clear();
        this.bedrockAnimations.clear();
        this.models.clear();
        this.soundBuffers.clear();
        this.languages.clear();
        this.tempGunModelMap.clear();
        this.tempAttachmentModelMap.clear();
        this.scriptsMap.clear();
        PlayerAnimatorCompat.clearAllAnimationCache();
    }
}

