/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.client.model.BedrockAmmoModel;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.entity.EntityKineticBullet;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityBulletRenderer
extends EntityRenderer<EntityKineticBullet> {
    public EntityBulletRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public static Optional<BedrockModel> getModel() {
        return InternalAssetLoader.getBedrockModel(InternalAssetLoader.DEFAULT_BULLET_MODEL);
    }

    public void render(EntityKineticBullet bullet, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ResourceLocation gunId = bullet.getGunId();
        ResourceLocation gunDisplayId = bullet.getGunDisplayId();
        Optional<GunDisplayInstance> display = TimelessAPI.getGunDisplay(gunDisplayId, gunId);
        if (display.isEmpty()) {
            return;
        }
        float @Nullable [] tracerColor = bullet.getTracerColorOverride().orElse(display.get().getTracerColor());
        ResourceLocation ammoId = bullet.getAmmoId();
        TimelessAPI.getClientAmmoIndex(ammoId).ifPresent(ammoIndex -> {
            BedrockAmmoModel ammoEntityModel = ammoIndex.getAmmoEntityModel();
            ResourceLocation textureLocation = ammoIndex.getAmmoEntityTextureLocation();
            if (ammoEntityModel != null && textureLocation != null) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)bullet.f_19859_, (float)bullet.m_146908_()) - 180.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)bullet.f_19860_, (float)bullet.m_146909_())));
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 1.5, 0.0);
                poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
                ammoEntityModel.render(poseStack, ItemDisplayContext.GROUND, RenderType.m_110470_((ResourceLocation)textureLocation), packedLight, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            }
            if (bullet.isTracerAmmo()) {
                float[] actualTracerColor = Objects.requireNonNullElse(tracerColor, ammoIndex.getTracerColor());
                this.renderTracerAmmo(bullet, actualTracerColor, partialTicks, poseStack, packedLight);
            }
        });
    }

    public void renderTracerAmmo(EntityKineticBullet bullet, float[] tracerColor, float partialTicks, PoseStack poseStack, int packedLight) {
        EntityBulletRenderer.getModel().ifPresent(model -> {
            Entity shooter = bullet.m_19749_();
            if (shooter == null) {
                return;
            }
            poseStack.m_85836_();
            float width = 0.005f;
            Vec3 bulletPosition = bullet.m_20318_(partialTicks);
            double trailLength = 0.85 * bullet.m_20184_().m_82553_();
            double disToEye = bulletPosition.m_82554_(shooter.m_20299_(partialTicks));
            trailLength = Math.min(trailLength, disToEye * 0.8);
            if (this.f_114476_.f_114360_.m_92176_().m_90612_() && bullet.m_19749_() instanceof LocalPlayer) {
                poseStack.m_85849_();
                return;
            }
            width *= bullet.getTracerSizeOverride();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)bullet.f_19859_, (float)bullet.m_146908_()) - 180.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)bullet.f_19860_, (float)bullet.m_146909_())));
            poseStack.m_85837_(0.0, -0.2, trailLength / 2.0);
            poseStack.m_85841_(width *= (float)Math.max(1.0, disToEye / 3.5), width, (float)trailLength);
            double bulletDistance = bulletPosition.m_82554_(shooter.m_146892_());
            if (bullet.f_19797_ >= 5 || bulletDistance > 2.0) {
                RenderType type = RenderType.m_110436_((ResourceLocation)InternalAssetLoader.DEFAULT_BULLET_TEXTURE, (float)15.0f, (float)15.0f);
                model.render(poseStack, ItemDisplayContext.NONE, type, packedLight, OverlayTexture.f_118083_, tracerColor[0], tracerColor[1], tracerColor[2], 1.0f);
            }
            poseStack.m_85849_();
        });
    }

    protected int getBlockLightLevel(@NotNull EntityKineticBullet entityBullet, @NotNull BlockPos blockPos) {
        return 15;
    }

    public boolean shouldRender(EntityKineticBullet bullet, Frustum camera, double pCamX, double pCamY, double pCamZ) {
        AABB aabb = bullet.m_6921_().m_82400_(0.5);
        if (aabb.m_82392_() || aabb.m_82309_() == 0.0) {
            aabb = new AABB(bullet.m_20185_() - 2.0, bullet.m_20186_() - 2.0, bullet.m_20189_() - 2.0, bullet.m_20185_() + 2.0, bullet.m_20186_() + 2.0, bullet.m_20189_() + 2.0);
        }
        return camera.m_113029_(aabb);
    }

    public ResourceLocation getTextureLocation(@NotNull EntityKineticBullet entity) {
        return null;
    }
}

